/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.state;

import is.codion.common.state.DefaultStateObserver;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import java.util.function.Consumer;
import java.util.function.Function;

final class DefaultState
implements State {
    private final Value<Boolean> value;
    private DefaultStateObserver observer;

    private DefaultState(Value.Builder<Boolean, ?> valueBuilder) {
        this.value = valueBuilder.consumer(new Notifier()).build();
    }

    public String toString() {
        return Boolean.toString((Boolean)this.value.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean get() {
        Value<Boolean> value = this.value;
        synchronized (value) {
            return (Boolean)this.value.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set(Boolean value) {
        Value<Boolean> value2 = this.value;
        synchronized (value2) {
            return this.value.set(value);
        }
    }

    @Override
    public void clear() {
        this.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean map(Function<Boolean, Boolean> mapper) {
        Value<Boolean> value = this.value;
        synchronized (value) {
            return this.value.map(mapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateObserver observer() {
        Value<Boolean> value = this.value;
        synchronized (value) {
            if (this.observer == null) {
                this.observer = new DefaultStateObserver(this, false);
            }
            return this.observer;
        }
    }

    @Override
    public StateObserver not() {
        return this.observer().not();
    }

    @Override
    public void link(Value<Boolean> originalValue) {
        this.value.link(originalValue);
    }

    @Override
    public void unlink(Value<Boolean> originalValue) {
        this.value.unlink(originalValue);
    }

    @Override
    public void link(ValueObserver<Boolean> originalValue) {
        this.value.link(originalValue);
    }

    @Override
    public void unlink(ValueObserver<Boolean> originalValue) {
        this.value.unlink(originalValue);
    }

    @Override
    public boolean addValidator(Value.Validator<? super Boolean> validator) {
        return this.value.addValidator(validator);
    }

    @Override
    public boolean removeValidator(Value.Validator<? super Boolean> validator) {
        return this.value.removeValidator(validator);
    }

    @Override
    public void validate(Boolean value) {
        this.value.validate(value);
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isNotNull() {
        return true;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean addListener(Runnable listener) {
        return this.observer().addListener(listener);
    }

    @Override
    public boolean removeListener(Runnable listener) {
        if (this.observer != null) {
            return this.observer.removeListener(listener);
        }
        return false;
    }

    @Override
    public boolean addConsumer(Consumer<? super Boolean> consumer) {
        return this.observer().addConsumer(consumer);
    }

    @Override
    public boolean removeConsumer(Consumer<? super Boolean> consumer) {
        if (this.observer != null) {
            return this.observer.removeConsumer(consumer);
        }
        return false;
    }

    @Override
    public boolean addWeakListener(Runnable listener) {
        return this.observer().addWeakListener(listener);
    }

    @Override
    public boolean removeWeakListener(Runnable listener) {
        if (this.observer != null) {
            return this.observer.removeWeakListener(listener);
        }
        return false;
    }

    @Override
    public boolean addWeakConsumer(Consumer<? super Boolean> consumer) {
        return this.observer().addWeakConsumer(consumer);
    }

    @Override
    public boolean removeWeakConsumer(Consumer<? super Boolean> consumer) {
        if (this.observer != null) {
            return this.observer.removeWeakConsumer(consumer);
        }
        return false;
    }

    private final class Notifier
    implements Consumer<Boolean> {
        private Notifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Boolean value) {
            Value<Boolean> value2 = DefaultState.this.value;
            synchronized (value2) {
                if (DefaultState.this.observer != null) {
                    DefaultState.this.observer.notifyObservers(value, value == false);
                }
            }
        }
    }

    static final class DefaultBuilder
    implements State.Builder {
        private final Value.Builder<Boolean, ?> valueBuilder = Value.nonNull(false);

        DefaultBuilder(boolean initialValue) {
            this.valueBuilder.initialValue(initialValue);
        }

        @Override
        public State.Builder notify(Value.Notify notify) {
            this.valueBuilder.notify(notify);
            return this;
        }

        @Override
        public State.Builder validator(Value.Validator<Boolean> validator) {
            this.valueBuilder.validator(validator);
            return this;
        }

        @Override
        public State.Builder link(Value<Boolean> originalState) {
            this.valueBuilder.link(originalState);
            return this;
        }

        @Override
        public State.Builder link(ValueObserver<Boolean> originalState) {
            this.valueBuilder.link(originalState);
            return this;
        }

        @Override
        public State.Builder listener(Runnable listener) {
            this.valueBuilder.listener(listener);
            return this;
        }

        @Override
        public State.Builder consumer(Consumer<Boolean> consumer) {
            this.valueBuilder.consumer(consumer);
            return this;
        }

        @Override
        public State.Builder weakListener(Runnable weakListener) {
            this.valueBuilder.weakListener(weakListener);
            return this;
        }

        @Override
        public State.Builder weakConsumer(Consumer<Boolean> weakConsumer) {
            this.valueBuilder.weakConsumer(weakConsumer);
            return this;
        }

        @Override
        public State build() {
            return new DefaultState(this.valueBuilder);
        }
    }
}

