/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.resource;

import is.codion.common.resource.MessageBundle;
import is.codion.common.resource.Resources;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

final class DefaultMessageBundle
extends ResourceBundle
implements MessageBundle {
    private static final Resources DEFAULT = new DefaultResources();
    private static final Resources RESOURCES = DefaultMessageBundle.resources();
    private final String baseBundleName;
    private final ResourceBundle bundle;

    DefaultMessageBundle(String baseBundleName, ResourceBundle bundle) {
        this.baseBundleName = Objects.requireNonNull(baseBundleName);
        this.bundle = bundle;
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.bundle.getKeys();
    }

    @Override
    protected Object handleGetObject(String key) {
        Objects.requireNonNull(key);
        if (!this.bundle.containsKey(key)) {
            throw new MissingResourceException("Can't find resource for bundle " + this.baseBundleName + ", key " + key, this.baseBundleName, key);
        }
        return RESOURCES.getString(this.baseBundleName, key, this.bundle.getString(key));
    }

    private static Resources resources() {
        try {
            ServiceLoader<Resources> loader = ServiceLoader.load(Resources.class);
            Iterator<Resources> iterator = loader.iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return DEFAULT;
        }
        catch (ServiceConfigurationError e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private static final class DefaultResources
    implements Resources {
        private DefaultResources() {
        }

        @Override
        public String getString(String baseBundleName, String key, String defaultString) {
            return defaultString;
        }
    }
}

