/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.logging;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public interface LoggerProxy {
    public static final LoggerProxy NULL_PROXY = new LoggerProxy(){
        private static final String NO_LOG_LEVEL = "NULL";

        @Override
        public Object getLogLevel() {
            return NO_LOG_LEVEL;
        }

        @Override
        public void setLogLevel(Object logLevel) {
        }

        @Override
        public List<Object> levels() {
            return Collections.emptyList();
        }
    };

    public Object getLogLevel();

    public void setLogLevel(Object var1);

    public List<Object> levels();

    default public Collection<String> files() {
        return Collections.emptyList();
    }

    public static LoggerProxy instance() {
        try {
            ServiceLoader<LoggerProxy> loader = ServiceLoader.load(LoggerProxy.class);
            Iterator<LoggerProxy> proxyIterator = loader.iterator();
            if (proxyIterator.hasNext()) {
                return proxyIterator.next();
            }
            System.err.println("No LoggerProxy service implementation found");
            return NULL_PROXY;
        }
        catch (ServiceConfigurationError e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

