/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.format;

import is.codion.common.format.LocaleDateTimePattern;
import java.io.Serializable;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class DefaultLocaleDateTimePattern
implements LocaleDateTimePattern,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FOUR_DIGIT_YEAR = "yyyy";
    private static final String TWO_DIGIT_YEAR = "yy";
    private static final String TWO_DIGIT_MONTH = "MM";
    private static final String TWO_DIGIT_DAY = "dd";
    private static final String HOURS_MINUTES = "HH:mm";
    private static final String HOURS_MINUTES_SECONDS = "HH:mm:ss";
    private static final String HOURS_MINUTES_SECONDS_MILLISECONDS = "HH:mm:ss.SSS";
    private final String delimiter;
    private final boolean fourDigitYear;
    private final String timePattern;

    private DefaultLocaleDateTimePattern(DefaultBuilder builder) {
        this.delimiter = Objects.requireNonNull(builder.delimiter, "delimiter");
        this.fourDigitYear = builder.fourDigitYear;
        this.timePattern = builder.timePattern;
    }

    @Override
    public Optional<String> timePattern() {
        return Optional.ofNullable(this.timePattern);
    }

    @Override
    public String datePattern() {
        return this.datePattern(Locale.getDefault());
    }

    @Override
    public String dateTimePattern() {
        return this.dateTimePattern(Locale.getDefault());
    }

    @Override
    public String datePattern(Locale locale) {
        return DefaultLocaleDateTimePattern.datePattern(locale, this.delimiter, this.fourDigitYear);
    }

    @Override
    public String dateTimePattern(Locale locale) {
        return DefaultLocaleDateTimePattern.dateTimePattern(locale, this.delimiter, this.fourDigitYear, this.timePattern);
    }

    @Override
    public DateTimeFormatter createFormatter() {
        return DateTimeFormatter.ofPattern(this.dateTimePattern());
    }

    private static String datePattern(Locale locale, String delimiter, boolean fourDigitYear) {
        return DefaultLocaleDateTimePattern.dateTimePattern(locale, delimiter, fourDigitYear, null);
    }

    private static String dateTimePattern(Locale locale, String delimiter, boolean fourDigitYear, String timePattern) {
        Objects.requireNonNull(locale);
        String datePattern = DateTimeFormatterBuilder.getLocalizedDateTimePattern(FormatStyle.SHORT, null, IsoChronology.INSTANCE, locale).toLowerCase(locale);
        ArrayList<String> pattern = new ArrayList<String>(Arrays.asList(null, null, null));
        pattern.set(DefaultLocaleDateTimePattern.indexOf(datePattern, Element.YEAR), fourDigitYear ? FOUR_DIGIT_YEAR : TWO_DIGIT_YEAR);
        pattern.set(DefaultLocaleDateTimePattern.indexOf(datePattern, Element.MONTH), TWO_DIGIT_MONTH);
        pattern.set(DefaultLocaleDateTimePattern.indexOf(datePattern, Element.DAY), TWO_DIGIT_DAY);
        StringBuilder builder = new StringBuilder(String.join((CharSequence)delimiter, pattern));
        if (timePattern != null) {
            builder.append(" ").append(timePattern);
        }
        return builder.toString();
    }

    private static int indexOf(String pattern, Element element) {
        return Stream.of(pattern.indexOf(121), pattern.indexOf(109), pattern.indexOf(100)).sorted().collect(Collectors.toList()).indexOf(pattern.indexOf(element.character()));
    }

    static final class DefaultBuilder
    implements LocaleDateTimePattern.Builder {
        private String delimiter = "";
        private boolean fourDigitYear = true;
        private String timePattern;

        DefaultBuilder() {
        }

        @Override
        public LocaleDateTimePattern.Builder delimiter(String delimiter) {
            this.delimiter = Objects.requireNonNull(delimiter);
            return this;
        }

        @Override
        public LocaleDateTimePattern.Builder delimiterDash() {
            return this.delimiter("-");
        }

        @Override
        public LocaleDateTimePattern.Builder delimiterDot() {
            return this.delimiter(".");
        }

        @Override
        public LocaleDateTimePattern.Builder delimiterSlash() {
            return this.delimiter("/");
        }

        @Override
        public LocaleDateTimePattern.Builder yearTwoDigits() {
            this.fourDigitYear = false;
            return this;
        }

        @Override
        public LocaleDateTimePattern.Builder yearFourDigits() {
            this.fourDigitYear = true;
            return this;
        }

        @Override
        public LocaleDateTimePattern.Builder hoursMinutes() {
            this.timePattern = DefaultLocaleDateTimePattern.HOURS_MINUTES;
            return this;
        }

        @Override
        public LocaleDateTimePattern.Builder hoursMinutesSeconds() {
            this.timePattern = DefaultLocaleDateTimePattern.HOURS_MINUTES_SECONDS;
            return this;
        }

        @Override
        public LocaleDateTimePattern.Builder hoursMinutesSecondsMilliseconds() {
            this.timePattern = DefaultLocaleDateTimePattern.HOURS_MINUTES_SECONDS_MILLISECONDS;
            return this;
        }

        @Override
        public LocaleDateTimePattern build() {
            return new DefaultLocaleDateTimePattern(this);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Element {
        YEAR{

            @Override
            char character() {
                return 'y';
            }
        }
        ,
        MONTH{

            @Override
            char character() {
                return 'm';
            }
        }
        ,
        DAY{

            @Override
            char character() {
                return 'd';
            }
        };


        abstract char character();
    }
}

