/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.event;

import is.codion.common.event.EventObserver;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

final class DefaultEventObserver<T>
implements EventObserver<T> {
    private static final String CONSUMER = "consumer";
    private static final String LISTENER = "listener";
    private final Object lock = new Object();
    private Set<Runnable> listeners;
    private Set<Consumer<? super T>> consumers;
    private List<WeakReference<Runnable>> weakListeners;
    private List<WeakReference<Consumer<? super T>>> weakConsumers;

    DefaultEventObserver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addConsumer(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer, CONSUMER);
        Object object = this.lock;
        synchronized (object) {
            return this.initConsumers().add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeConsumer(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer, CONSUMER);
        Object object = this.lock;
        synchronized (object) {
            return this.initConsumers().remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addListener(Runnable listener) {
        Objects.requireNonNull(listener, LISTENER);
        Object object = this.lock;
        synchronized (object) {
            return this.initListeners().add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(Runnable listener) {
        Objects.requireNonNull(listener, LISTENER);
        Object object = this.lock;
        synchronized (object) {
            return this.initListeners().remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addWeakListener(Runnable listener) {
        Objects.requireNonNull(listener, LISTENER);
        Object object = this.lock;
        synchronized (object) {
            List<WeakReference<Runnable>> references = this.initWeakListeners();
            for (WeakReference<Runnable> reference : references) {
                if (reference.get() != listener) continue;
                return false;
            }
            return references.add(new WeakReference<Runnable>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeWeakListener(Runnable listener) {
        Objects.requireNonNull(listener, LISTENER);
        Object object = this.lock;
        synchronized (object) {
            return this.initWeakListeners().removeIf(reference -> reference.get() == null || reference.get() == listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addWeakConsumer(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer, CONSUMER);
        Object object = this.lock;
        synchronized (object) {
            List<WeakReference<Consumer<T>>> references = this.initWeakConsumers();
            for (WeakReference<Consumer<T>> reference : references) {
                if (reference.get() != consumer) continue;
                return false;
            }
            return references.add(new WeakReference<Consumer<? super T>>(consumer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeWeakConsumer(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer, CONSUMER);
        Object object = this.lock;
        synchronized (object) {
            return this.initWeakConsumers().removeIf(reference -> reference.get() == null || reference.get() == consumer);
        }
    }

    void notifyListeners(T data) {
        for (Runnable runnable : this.listeners()) {
            runnable.run();
        }
        for (Consumer consumer : this.consumers()) {
            consumer.accept(data);
        }
        for (WeakReference weakReference : this.weakListeners()) {
            Runnable weakListener = (Runnable)weakReference.get();
            if (weakListener == null) continue;
            weakListener.run();
        }
        for (WeakReference weakReference : this.weakConsumers()) {
            Consumer consumer = (Consumer)weakReference.get();
            if (consumer == null) continue;
            consumer.accept(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Runnable> listeners() {
        Object object = this.lock;
        synchronized (object) {
            if (this.listeners != null && !this.listeners.isEmpty()) {
                return new ArrayList<Runnable>(this.listeners);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Consumer<? super T>> consumers() {
        Object object = this.lock;
        synchronized (object) {
            if (this.consumers != null && !this.consumers.isEmpty()) {
                return new ArrayList<Consumer<? super T>>(this.consumers);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WeakReference<Runnable>> weakListeners() {
        Object object = this.lock;
        synchronized (object) {
            if (this.weakListeners != null && !this.weakListeners.isEmpty()) {
                this.weakListeners.removeIf(reference -> reference.get() == null);
                return new ArrayList<WeakReference<Runnable>>(this.weakListeners);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WeakReference<Consumer<? super T>>> weakConsumers() {
        Object object = this.lock;
        synchronized (object) {
            if (this.weakConsumers != null && !this.weakConsumers.isEmpty()) {
                this.weakConsumers.removeIf(reference -> reference.get() == null);
                return new ArrayList<WeakReference<Consumer<? super T>>>(this.weakConsumers);
            }
        }
        return Collections.emptyList();
    }

    private Set<Runnable> initListeners() {
        if (this.listeners == null) {
            this.listeners = new LinkedHashSet<Runnable>(1);
        }
        return this.listeners;
    }

    private Set<Consumer<? super T>> initConsumers() {
        if (this.consumers == null) {
            this.consumers = new LinkedHashSet<Consumer<? super T>>(1);
        }
        return this.consumers;
    }

    private List<WeakReference<Runnable>> initWeakListeners() {
        if (this.weakListeners == null) {
            this.weakListeners = new ArrayList<WeakReference<Runnable>>(1);
        }
        return this.weakListeners;
    }

    private List<WeakReference<Consumer<? super T>>> initWeakConsumers() {
        if (this.weakConsumers == null) {
            this.weakConsumers = new ArrayList<WeakReference<Consumer<? super T>>>(1);
        }
        return this.weakConsumers;
    }
}

