/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common;

import is.codion.common.Configuration;
import is.codion.common.property.PropertyValue;
import java.io.Serializable;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Text {
    public static final PropertyValue<String> DEFAULT_COLLATOR_LANGUAGE = Configuration.stringValue("codion.defaultCollatorLanguage", Locale.getDefault().getLanguage());
    public static final PropertyValue<Character> WILDCARD_CHARACTER = Configuration.characterValue("codion.wildcardCharacter", '%');

    private Text() {
    }

    public static <T> List<T> collate(List<T> values) {
        Objects.requireNonNull(values).sort(Text.collator());
        return values;
    }

    public static <T> Comparator<T> collator() {
        return Text.collator(new Locale((String)DEFAULT_COLLATOR_LANGUAGE.get()));
    }

    public static <T> Comparator<T> collator(Locale locale) {
        return new SpaceAwareComparator(Objects.requireNonNull(locale));
    }

    public static String rightPad(String string, int length, char padChar) {
        return Text.padString(string, length, padChar, false);
    }

    public static String leftPad(String string, int length, char padChar) {
        return Text.padString(string, length, padChar, true);
    }

    public static List<String> parseCommaSeparatedValues(String commaSeparatedValues) {
        if (Text.nullOrEmpty(commaSeparatedValues)) {
            return Collections.emptyList();
        }
        return Arrays.stream(commaSeparatedValues.split(",")).map(String::trim).filter(string -> !string.isEmpty()).collect(Collectors.toList());
    }

    private static String padString(String string, int length, char padChar, boolean left) {
        if (Objects.requireNonNull(string, "string").length() >= length) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        while (stringBuilder.length() < length) {
            if (left) {
                stringBuilder.insert(0, padChar);
                continue;
            }
            stringBuilder.append(padChar);
        }
        return stringBuilder.toString();
    }

    public static boolean nullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean nullOrEmpty(String ... strings) {
        if (strings == null || strings.length == 0) {
            return true;
        }
        for (int i = 0; i < strings.length; ++i) {
            if (!Text.nullOrEmpty(strings[i])) continue;
            return true;
        }
        return false;
    }

    private static final class SpaceAwareComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final char SPACE = ' ';
        private static final char UNDERSCORE = '_';
        private final Locale locale;
        private transient Collator collator;

        private SpaceAwareComparator(Locale locale) {
            this.locale = locale;
        }

        @Override
        public int compare(T o1, T o2) {
            String s1 = o1 == null ? "" : o1.toString();
            String s2 = o2 == null ? "" : o2.toString();
            return this.collator().compare(s1.replace(' ', '_'), s2.replace(' ', '_'));
        }

        private Collator collator() {
            if (this.collator == null) {
                this.collator = Collator.getInstance(this.locale);
            }
            return this.collator;
        }
    }
}

