/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.version;

import is.codion.common.version.Version;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

final class DefaultVersion
implements Version,
Serializable {
    private static final long serialVersionUID = 1L;
    static final Version VERSION = Version.parse(DefaultVersion.class, "version.properties");
    private final int major;
    private final int minor;
    private final int patch;
    private final String metadata;
    private final String build;

    private DefaultVersion(DefaulBuilder builder) {
        this.major = builder.major;
        this.minor = builder.minor;
        this.patch = builder.patch;
        this.metadata = builder.metadata;
        this.build = builder.build;
    }

    @Override
    public int major() {
        return this.major;
    }

    @Override
    public int minor() {
        return this.minor;
    }

    @Override
    public int patch() {
        return this.patch;
    }

    @Override
    public Optional<String> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    @Override
    public Optional<String> build() {
        return Optional.ofNullable(this.build);
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch + (String)(this.metadata == null ? "" : "-" + this.metadata) + (String)(this.build == null ? "" : "+" + this.build);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultVersion that = (DefaultVersion)obj;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.build, that.build);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.metadata, this.build);
    }

    @Override
    public int compareTo(Version version) {
        int result = Integer.compare(this.major, version.major());
        if (result == 0) {
            result = Integer.compare(this.minor, version.minor());
            if (result == 0) {
                result = Integer.compare(this.patch, version.patch());
            }
            if (result == 0) {
                result = DefaultVersion.compareMetadata(this.metadata, version.metadata().orElse(null));
            }
        }
        return result;
    }

    private static int compareMetadata(String metadata, String toCompare) {
        if (metadata != null && toCompare != null) {
            return metadata.compareToIgnoreCase(toCompare);
        }
        if (metadata != null && toCompare == null) {
            return -1;
        }
        if (metadata == null && toCompare != null) {
            return 1;
        }
        return 0;
    }

    static final class DefaulBuilder
    implements Version.Builder {
        private int major = 0;
        private int minor = 0;
        private int patch = 0;
        private String metadata;
        private String build;

        DefaulBuilder() {
        }

        @Override
        public Version.Builder major(int major) {
            if (major < 0) {
                throw new IllegalArgumentException("Major must be a non-negative integer");
            }
            this.major = major;
            return this;
        }

        @Override
        public Version.Builder minor(int minor) {
            if (minor < 0) {
                throw new IllegalArgumentException("Minor must be a non-negative integer");
            }
            this.minor = minor;
            return this;
        }

        @Override
        public Version.Builder patch(int patch) {
            if (patch < 0) {
                throw new IllegalArgumentException("Patch must be a non-negative integer");
            }
            this.patch = patch;
            return this;
        }

        @Override
        public Version.Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public Version.Builder build(String build) {
            this.build = build;
            return this;
        }

        @Override
        public Version build() {
            return new DefaultVersion(this);
        }
    }
}

