/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.value;

import is.codion.common.value.DefaultValue;
import is.codion.common.value.ValueObserver;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Value<T>
extends ValueObserver<T>,
Consumer<T> {
    @Override
    default public void accept(T value) {
        this.set(value);
    }

    public boolean set(T var1);

    public void clear();

    default public boolean map(Function<T, T> mapper) {
        return this.set(Objects.requireNonNull(mapper).apply(this.get()));
    }

    default public boolean mapNull(Supplier<T> supplier) {
        Objects.requireNonNull(supplier);
        if (this.isNull()) {
            return this.set(supplier.get());
        }
        return false;
    }

    public ValueObserver<T> observer();

    public void link(Value<T> var1);

    public void unlink(Value<T> var1);

    public void link(ValueObserver<T> var1);

    public void unlink(ValueObserver<T> var1);

    public boolean addValidator(Validator<T> var1);

    public boolean removeValidator(Validator<T> var1);

    public void validate(T var1);

    public static <T> Value<T> value() {
        return Value.nullable(null).build();
    }

    public static <T> Builder<T, ?> nonNull(T nullValue) {
        return new DefaultValue.DefaultBuilder(nullValue);
    }

    public static <T> Builder<T, ?> nullable() {
        return Value.nullable(null);
    }

    public static <T> Builder<T, ?> nullable(T initialValue) {
        return new DefaultValue.DefaultBuilder().initialValue(initialValue);
    }

    public static interface Builder<T, B extends Builder<T, B>> {
        public B initialValue(T var1);

        public B notify(Notify var1);

        public B validator(Validator<T> var1);

        public B link(Value<T> var1);

        public B link(ValueObserver<T> var1);

        public B listener(Runnable var1);

        public B consumer(Consumer<T> var1);

        public B weakListener(Runnable var1);

        public B weakConsumer(Consumer<T> var1);

        public Value<T> build();
    }

    public static interface Validator<T> {
        public void validate(T var1);
    }

    public static enum Notify {
        WHEN_SET,
        WHEN_CHANGED;

    }
}

