/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.state;

import is.codion.common.event.Event;
import is.codion.common.event.EventObserver;
import is.codion.common.state.StateObserver;
import java.util.Objects;
import java.util.function.Consumer;

final class DefaultStateObserver
implements StateObserver {
    private final Object lock = new Object();
    private final StateObserver observedState;
    private final boolean not;
    private Event<Boolean> stateChangedEvent;
    private DefaultStateObserver notObserver;

    DefaultStateObserver(StateObserver observedState, boolean not) {
        this.observedState = Objects.requireNonNull(observedState);
        this.not = not;
    }

    public String toString() {
        return Boolean.toString(this.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean get() {
        Object object = this.lock;
        synchronized (object) {
            return this.not ? !((Boolean)this.observedState.get()).booleanValue() : (Boolean)this.observedState.get();
        }
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isNotNull() {
        return true;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateObserver not() {
        if (this.not) {
            return this.observedState;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.notObserver == null) {
                this.notObserver = new DefaultStateObserver(this, true);
            }
            return this.notObserver;
        }
    }

    @Override
    public boolean addListener(Runnable listener) {
        return this.eventObserver().addListener(listener);
    }

    @Override
    public boolean removeListener(Runnable listener) {
        return this.eventObserver().removeListener(listener);
    }

    @Override
    public boolean addConsumer(Consumer<? super Boolean> consumer) {
        return this.eventObserver().addConsumer(consumer);
    }

    @Override
    public boolean removeConsumer(Consumer<? super Boolean> consumer) {
        return this.eventObserver().removeConsumer(consumer);
    }

    @Override
    public boolean addWeakListener(Runnable listener) {
        return this.eventObserver().addWeakListener(listener);
    }

    @Override
    public boolean removeWeakListener(Runnable listener) {
        return this.eventObserver().removeWeakListener(listener);
    }

    @Override
    public boolean addWeakConsumer(Consumer<? super Boolean> consumer) {
        return this.eventObserver().addWeakConsumer(consumer);
    }

    @Override
    public boolean removeWeakConsumer(Consumer<? super Boolean> consumer) {
        return this.eventObserver().removeWeakConsumer(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyObservers(boolean newValue, boolean previousValue) {
        Object object = this.lock;
        synchronized (object) {
            if (previousValue != newValue) {
                if (this.stateChangedEvent != null) {
                    this.stateChangedEvent.accept(newValue);
                }
                if (this.notObserver != null) {
                    this.notObserver.notifyObservers(previousValue, newValue);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventObserver<Boolean> eventObserver() {
        Object object = this.lock;
        synchronized (object) {
            if (this.stateChangedEvent == null) {
                this.stateChangedEvent = Event.event();
            }
            return this.stateChangedEvent.observer();
        }
    }
}

