/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.version;

import is.codion.common.version.DefaultVersion;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;

public interface Version
extends Comparable<Version> {
    public static final String VERSION_PROPERTY_KEY = "version";

    public int major();

    public int minor();

    public int patch();

    public Optional<String> metadata();

    public Optional<String> build();

    public static Builder builder() {
        return new DefaultVersion.DefaulBuilder();
    }

    public static String versionString() {
        String versionString = Version.versionAndMetadataString();
        if (versionString.toLowerCase().contains("-")) {
            return versionString.substring(0, versionString.toLowerCase().indexOf(45));
        }
        return versionString;
    }

    public static String versionAndMetadataString() {
        return DefaultVersion.VERSION.toString();
    }

    public static Version version() {
        return DefaultVersion.VERSION;
    }

    public static Version parse(String versionString) {
        String build;
        String metadata;
        String version;
        if (versionString == null || versionString.isEmpty()) {
            throw new IllegalArgumentException("Invalid version string: " + versionString);
        }
        int dashIndex = versionString.indexOf(45);
        int plusIndex = versionString.indexOf(43);
        if (dashIndex != -1 && plusIndex != -1) {
            version = versionString.substring(0, dashIndex);
            metadata = versionString.substring(dashIndex + 1, plusIndex);
            build = versionString.substring(plusIndex + 1);
        } else if (dashIndex != -1) {
            version = versionString.substring(0, dashIndex);
            metadata = versionString.substring(dashIndex + 1);
            build = null;
        } else if (plusIndex != -1) {
            version = versionString.substring(0, plusIndex);
            build = versionString.substring(plusIndex + 1);
            metadata = null;
        } else {
            version = versionString;
            metadata = null;
            build = null;
        }
        String[] versionSplit = version.split("\\.");
        int major = versionSplit.length > 0 ? Integer.parseInt(versionSplit[0]) : 0;
        int minor = versionSplit.length > 1 ? Integer.parseInt(versionSplit[1]) : 0;
        int patch = versionSplit.length > 2 ? Integer.parseInt(versionSplit[2]) : 0;
        return Version.builder().major(major).minor(minor).patch(patch).metadata(metadata).build(build).build();
    }

    public static Version parse(Class<?> resourceOwner, String versionFileResourcePath) {
        Version version;
        block10: {
            InputStream resourceStream = Objects.requireNonNull(resourceOwner).getResourceAsStream(Objects.requireNonNull(versionFileResourcePath));
            try {
                if (resourceStream == null) {
                    throw new IllegalArgumentException("Version resource not found: " + resourceOwner + ", " + versionFileResourcePath);
                }
                Properties properties = new Properties();
                properties.load(resourceStream);
                String version2 = properties.getProperty(VERSION_PROPERTY_KEY);
                if (version2 == null) {
                    throw new IllegalArgumentException("No 'version' property found: " + resourceOwner + ", " + versionFileResourcePath);
                }
                version = Version.parse(version2);
                if (resourceStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceStream != null) {
                        try {
                            resourceStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to parse version information", e);
                }
            }
            resourceStream.close();
        }
        return version;
    }

    public static interface Builder {
        public Builder major(int var1);

        public Builder minor(int var1);

        public Builder patch(int var1);

        public Builder metadata(String var1);

        public Builder build(String var1);

        public Version build();
    }
}

