/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.value;

import is.codion.common.value.DefaultValueSet;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSetObserver;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public interface ValueSet<T>
extends Value<Set<T>>,
ValueSetObserver<T> {
    public void set(Collection<T> var1);

    public boolean add(T var1);

    public boolean addAll(T ... var1);

    public boolean addAll(Collection<T> var1);

    public boolean remove(T var1);

    public boolean removeAll(T ... var1);

    public boolean removeAll(Collection<T> var1);

    public void clear();

    @Override
    public Value<T> value();

    @Override
    public ValueSetObserver<T> observer();

    public static <T> ValueSet<T> valueSet() {
        return ValueSet.builder(Collections.emptySet()).build();
    }

    public static <T> ValueSet<T> valueSet(Set<T> initialValue) {
        return ValueSet.builder(initialValue).build();
    }

    public static <T> Builder<T> builder(Set<T> initialValue) {
        return new DefaultValueSet.DefaultBuilder<T>().initialValue(initialValue);
    }

    public static interface Builder<T> {
        public Builder<T> initialValue(Set<T> var1);

        public Builder<T> notify(Value.Notify var1);

        public Builder<T> validator(Value.Validator<Set<T>> var1);

        public Builder<T> link(ValueSet<T> var1);

        public Builder<T> link(ValueSetObserver<T> var1);

        public ValueSet<T> build();
    }
}

