/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.value;

import is.codion.common.value.DefaultValue;
import is.codion.common.value.ValueObserver;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Value<T>
extends ValueObserver<T>,
Consumer<T> {
    @Override
    default public void accept(T value) {
        this.set(value);
    }

    public boolean set(T var1);

    default public boolean map(Function<T, T> mapper) {
        return this.set(Objects.requireNonNull(mapper).apply(this.get()));
    }

    default public boolean mapNull(Supplier<T> supplier) {
        Objects.requireNonNull(supplier);
        if (this.isNull()) {
            return this.set(supplier.get());
        }
        return false;
    }

    public ValueObserver<T> observer();

    public void link(Value<T> var1);

    public void unlink(Value<T> var1);

    public void link(ValueObserver<T> var1);

    public void unlink(ValueObserver<T> var1);

    public boolean addValidator(Validator<T> var1);

    public boolean removeValidator(Validator<T> var1);

    public void validate(T var1);

    public static <T> Value<T> value() {
        return Value.nullable(null).build();
    }

    public static <T> Builder<T> nonNull(T nullValue) {
        return new DefaultValue.DefaultBuilder<T>(nullValue);
    }

    public static <T> Builder<T> nullable(T initialValue) {
        return new DefaultValue.DefaultBuilder<T>().initialValue(initialValue);
    }

    public static interface Builder<T> {
        public Builder<T> initialValue(T var1);

        public Builder<T> notify(Notify var1);

        public Builder<T> validator(Validator<T> var1);

        public Builder<T> link(Value<T> var1);

        public Builder<T> link(ValueObserver<T> var1);

        public Value<T> build();
    }

    public static interface Validator<T> {
        public void validate(T var1);
    }

    public static enum Notify {
        WHEN_SET,
        WHEN_CHANGED;

    }
}

