/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.value;

import is.codion.common.value.AbstractValue;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

final class DefaultValue<T>
extends AbstractValue<T> {
    private T value;

    private DefaultValue(DefaultBuilder<T> builder) {
        super(builder.nullValue, builder.notify);
        this.set(builder.initialValue);
        builder.validators.forEach(this::addValidator);
        builder.linkedValues.forEach(this::link);
        builder.linkedObservers.forEach(this::link);
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    protected void setValue(T value) {
        this.value = value;
    }

    static final class DefaultBuilder<T>
    implements Value.Builder<T> {
        private final T nullValue;
        private final List<Value.Validator<T>> validators = new ArrayList<Value.Validator<T>>();
        private final List<Value<T>> linkedValues = new ArrayList<Value<T>>();
        private final List<ValueObserver<T>> linkedObservers = new ArrayList<ValueObserver<T>>();
        private T initialValue;
        private Value.Notify notify = Value.Notify.WHEN_CHANGED;

        DefaultBuilder() {
            this.nullValue = null;
        }

        DefaultBuilder(T nullValue) {
            this.nullValue = Objects.requireNonNull(nullValue);
            this.initialValue = nullValue;
        }

        @Override
        public Value.Builder<T> initialValue(T initialValue) {
            this.initialValue = initialValue == null ? this.nullValue : initialValue;
            return this;
        }

        @Override
        public Value.Builder<T> notify(Value.Notify notify) {
            this.notify = Objects.requireNonNull(notify);
            return this;
        }

        @Override
        public Value.Builder<T> validator(Value.Validator<T> validator) {
            this.validators.add(Objects.requireNonNull(validator));
            return this;
        }

        @Override
        public Value.Builder<T> link(Value<T> originalValue) {
            this.linkedValues.add(Objects.requireNonNull(originalValue));
            return this;
        }

        @Override
        public Value.Builder<T> link(ValueObserver<T> originalValue) {
            this.linkedObservers.add(Objects.requireNonNull(originalValue));
            return this;
        }

        @Override
        public Value<T> build() {
            return new DefaultValue(this);
        }
    }
}

