/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.state;

import is.codion.common.state.State;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

final class DefaultStateGroup
implements State.Group {
    private final List<WeakReference<State>> members = new ArrayList<WeakReference<State>>();

    DefaultStateGroup(State ... states) {
        for (State state : Objects.requireNonNull(states)) {
            this.add(state);
        }
    }

    DefaultStateGroup(Collection<State> states) {
        for (State state : Objects.requireNonNull(states)) {
            this.add(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(State state) {
        Objects.requireNonNull(state);
        List<WeakReference<State>> list = this.members;
        synchronized (list) {
            if (this.members.stream().anyMatch(reference -> reference.get() == state)) {
                return;
            }
            this.members.add(new WeakReference<State>(state));
            this.stateChanged(state);
        }
        state.addConsumer(value -> {
            List<WeakReference<State>> list = this.members;
            synchronized (list) {
                if (value.booleanValue()) {
                    this.stateChanged(state);
                }
            }
        });
    }

    @Override
    public void add(Collection<State> states) {
        Objects.requireNonNull(states).forEach(this::add);
    }

    private void stateChanged(State state) {
        this.members.removeIf(reference -> reference.get() == null);
        if (((Boolean)state.get()).booleanValue()) {
            this.members.stream().map(Reference::get).filter(s -> s != state).forEach(s -> s.set(false));
        }
    }
}

