/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.scheduler;

import is.codion.common.scheduler.TaskScheduler;
import is.codion.common.value.Value;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

final class DefaultTaskScheduler
implements TaskScheduler {
    private final Object lock = new Object();
    private final Runnable task;
    private final Value<Integer> interval;
    private final int initialDelay;
    private final TimeUnit timeUnit;
    private final ThreadFactory threadFactory;
    private ScheduledExecutorService executorService;

    private DefaultTaskScheduler(DefaultBuilder builder) {
        this.task = builder.task;
        this.interval = Value.nonNull(builder.interval).build();
        this.interval.addValidator(value -> {
            if (value <= 0) {
                throw new IllegalArgumentException("Interval must be a positive integer");
            }
        });
        this.initialDelay = builder.initialDelay;
        this.timeUnit = builder.timeUnit;
        this.threadFactory = builder.threadFactory;
        this.interval.addListener(this::onIntervalChanged);
    }

    @Override
    public Value<Integer> interval() {
        return this.interval;
    }

    @Override
    public TimeUnit timeUnit() {
        return this.timeUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultTaskScheduler start() {
        Object object = this.lock;
        synchronized (object) {
            this.stop();
            this.executorService = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
            this.executorService.scheduleAtFixedRate(this.task, this.initialDelay, ((Integer)this.interval.get()).intValue(), this.timeUnit);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.running()) {
                this.executorService.shutdownNow();
                this.executorService = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean running() {
        Object object = this.lock;
        synchronized (object) {
            return this.executorService != null && !this.executorService.isShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onIntervalChanged() {
        Object object = this.lock;
        synchronized (object) {
            if (this.running()) {
                this.start();
            }
        }
    }

    static final class DefaultBuilder
    implements TaskScheduler.Builder {
        private final Runnable task;
        private int interval;
        private int initialDelay;
        private TimeUnit timeUnit;
        private ThreadFactory threadFactory = new DaemonThreadFactory();

        DefaultBuilder(Runnable task) {
            this.task = Objects.requireNonNull(task);
        }

        @Override
        public TaskScheduler.Builder interval(int interval, TimeUnit timeUnit) {
            if (interval <= 0) {
                throw new IllegalArgumentException("Interval must be a positive integer");
            }
            this.interval = interval;
            this.timeUnit = Objects.requireNonNull(timeUnit);
            return this;
        }

        @Override
        public TaskScheduler.Builder initialDelay(int initialDelay) {
            if (initialDelay < 0) {
                throw new IllegalArgumentException("Initial delay can not be negative");
            }
            this.initialDelay = initialDelay;
            return this;
        }

        @Override
        public TaskScheduler.Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = Objects.requireNonNull(threadFactory);
            return this;
        }

        @Override
        public TaskScheduler start() {
            TaskScheduler taskScheduler = this.build();
            taskScheduler.start();
            return taskScheduler;
        }

        @Override
        public TaskScheduler build() {
            if (this.interval == 0) {
                throw new IllegalStateException("An interval > 0 is required for building a TaskScheduler");
            }
            if (this.timeUnit == null) {
                throw new IllegalStateException("A time unit is required for building a TaskScheduler");
            }
            return new DefaultTaskScheduler(this);
        }
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }
}

