/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class Serializer {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    private Serializer() {
    }

    public static byte[] serialize(Object object) throws IOException {
        if (object != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new ObjectOutputStream(byteArrayOutputStream).writeObject(object);
            return byteArrayOutputStream.toByteArray();
        }
        return EMPTY_BYTE_ARRAY;
    }

    public static <T> T deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        if (bytes != null && bytes.length > 0) {
            return (T)new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
        }
        return null;
    }
}

