/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.value;

import is.codion.common.value.AbstractValue;
import is.codion.common.value.DefaultValueSetObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.common.value.ValueSet;
import is.codion.common.value.ValueSetObserver;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

final class DefaultValueSet<T>
extends AbstractValue<Set<T>>
implements ValueSet<T> {
    private final Set<T> values = new LinkedHashSet<T>();
    private Value<T> value;

    DefaultValueSet(Set<T> initialValues, Value.Notify notify) {
        super(Collections.emptySet(), notify);
        this.set(Objects.requireNonNull(initialValues, "initialValues"));
    }

    @Override
    public Iterator<T> iterator() {
        return this.get().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(Collection<T> values) {
        Set<T> set = this.values;
        synchronized (set) {
            this.set(values == null ? null : new LinkedHashSet<T>(values));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<T> get() {
        Set<T> set = this.values;
        synchronized (set) {
            return Collections.unmodifiableSet(new LinkedHashSet<T>(this.values));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T value) {
        Set<T> set = this.values;
        synchronized (set) {
            LinkedHashSet<T> newValues = new LinkedHashSet<T>(this.values);
            boolean added = newValues.add(value);
            this.set(newValues);
            return added;
        }
    }

    @Override
    public boolean addAll(T ... values) {
        return this.addAll((Collection<T>)Arrays.asList(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<T> values) {
        Objects.requireNonNull(values);
        Set<T> set = this.values;
        synchronized (set) {
            LinkedHashSet<T> newValues = new LinkedHashSet<T>(this.values);
            boolean added = false;
            for (T val : values) {
                added = newValues.add(val) || added;
            }
            this.set(newValues);
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(T value) {
        Set<T> set = this.values;
        synchronized (set) {
            LinkedHashSet<T> newValues = new LinkedHashSet<T>(this.values);
            boolean removed = newValues.remove(value);
            this.set(newValues);
            return removed;
        }
    }

    @Override
    public boolean removeAll(T ... values) {
        return this.removeAll((Collection<T>)Arrays.asList(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<T> values) {
        Objects.requireNonNull(values);
        Set<T> set = this.values;
        synchronized (set) {
            LinkedHashSet<T> newValues = new LinkedHashSet<T>(this.values);
            boolean removed = false;
            for (T val : values) {
                removed = newValues.remove(val) || removed;
            }
            this.set(newValues);
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(T value) {
        Set<T> set = this.values;
        synchronized (set) {
            return this.values.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<T> values) {
        Objects.requireNonNull(values);
        Set<T> set = this.values;
        synchronized (set) {
            return this.values.containsAll(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean empty() {
        Set<T> set = this.values;
        synchronized (set) {
            return this.values.isEmpty();
        }
    }

    @Override
    public boolean notEmpty() {
        return !this.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Set<T> set = this.values;
        synchronized (set) {
            return this.values.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Set<T> set = this.values;
        synchronized (set) {
            this.set(Collections.emptySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<T> value() {
        Set<T> set = this.values;
        synchronized (set) {
            if (this.value == null) {
                this.value = new SingleValue();
            }
            return this.value;
        }
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public synchronized ValueSetObserver<T> observer() {
        return (ValueSetObserver)super.observer();
    }

    @Override
    protected ValueObserver<Set<T>> createObserver() {
        return new DefaultValueSetObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setValue(Set<T> values) {
        Set<T> set = this.values;
        synchronized (set) {
            this.values.clear();
            this.values.addAll(values);
        }
    }

    private class SingleValue
    extends AbstractValue<T> {
        private SingleValue() {
            super(null);
            DefaultValueSet.this.addListener(this::notifyListeners);
        }

        @Override
        public T get() {
            Object set = DefaultValueSet.this.get();
            return set.isEmpty() ? null : (Object)set.iterator().next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void setValue(T value) {
            Set set = DefaultValueSet.this.values;
            synchronized (set) {
                DefaultValueSet.this.set(value == null ? Collections.emptySet() : Collections.singleton(value));
            }
        }
    }
}

