/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.version;

import is.codion.common.version.Version;
import java.io.Serializable;
import java.util.Objects;

final class DefaultVersion
implements Version,
Serializable {
    private static final long serialVersionUID = 1L;
    static final Version VERSION = Version.parsePropertiesFile(DefaultVersion.class, "version.properties");
    private final int major;
    private final int minor;
    private final int patch;
    private final String metadata;

    DefaultVersion(int major, int minor, int patch, String metadata) {
        if (major < 0 || minor < 0 || patch < 0) {
            throw new IllegalArgumentException("Major, minor and patch must be non-negative integers");
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.metadata = metadata;
    }

    @Override
    public int major() {
        return this.major;
    }

    @Override
    public int minor() {
        return this.minor;
    }

    @Override
    public int patch() {
        return this.patch;
    }

    @Override
    public String metadata() {
        return this.metadata;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch + (String)(this.metadata == null ? "" : "-" + this.metadata);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultVersion that = (DefaultVersion)obj;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.metadata);
    }

    @Override
    public int compareTo(Version version) {
        int result = Integer.compare(this.major, version.major());
        if (result == 0) {
            result = Integer.compare(this.minor, version.minor());
            if (result == 0) {
                result = Integer.compare(this.patch, version.patch());
            }
            if (result == 0) {
                result = DefaultVersion.compareMetadata(this.metadata, version.metadata());
            }
        }
        return result;
    }

    private static int compareMetadata(String metadata, String toCompare) {
        if (metadata != null && toCompare != null) {
            return metadata.compareToIgnoreCase(toCompare);
        }
        if (metadata != null && toCompare == null) {
            return -1;
        }
        if (metadata == null && toCompare != null) {
            return 1;
        }
        return 0;
    }
}

