/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.value;

import is.codion.common.value.AbstractValue;
import is.codion.common.value.Value;
import java.util.Set;

final class ValueLink<T> {
    private final Value<T> linkedValue;
    private final Value<T> originalValue;
    private final Runnable updateLinkedValue = new UpdateLinkedValue();
    private final Runnable updateOriginalValue = new UpdateOriginalValue();
    private final LinkedValidator<T> linkedValidator;
    private final LinkedValidator<T> originalValidator;
    private boolean updatingLinked = false;
    private boolean updatingOriginal = false;

    ValueLink(Value<T> linkedValue, Value<T> originalValue) {
        ValueLink.preventLinkCycle(linkedValue, originalValue);
        this.linkedValue = linkedValue;
        this.originalValue = originalValue;
        this.linkedValidator = new LinkedValidator<T>(linkedValue);
        this.originalValidator = new LinkedValidator<T>(originalValue);
        this.linkedValidator.excluded = this.originalValidator;
        this.originalValidator.excluded = this.linkedValidator;
        linkedValue.set(originalValue.get());
        originalValue.addListener(this.updateLinkedValue);
        linkedValue.addListener(this.updateOriginalValue);
        originalValue.addValidator(this.linkedValidator);
        linkedValue.addValidator(this.originalValidator);
    }

    void unlink() {
        this.linkedValue.removeListener(this.updateOriginalValue);
        this.originalValue.removeListener(this.updateLinkedValue);
        this.linkedValue.removeValidator(this.originalValidator);
        this.originalValue.removeValidator(this.linkedValidator);
    }

    private static <T> void preventLinkCycle(Value<T> linkedValue, Value<T> originalValue) {
        if (originalValue == linkedValue) {
            throw new IllegalArgumentException("A Value can not be linked to itself");
        }
        if (originalValue instanceof AbstractValue) {
            Set<Value<Value>> linkedValues = ((AbstractValue)originalValue).linkedValues();
            if (linkedValues.contains(linkedValue)) {
                throw new IllegalStateException("Cyclical value link detected");
            }
            linkedValues.forEach(value -> ValueLink.preventLinkCycle(value, originalValue));
        }
    }

    private final class UpdateLinkedValue
    implements Runnable {
        private UpdateLinkedValue() {
        }

        @Override
        public void run() {
            this.updateLinkedValue();
        }

        private void updateLinkedValue() {
            if (!ValueLink.this.updatingOriginal) {
                try {
                    ValueLink.this.updatingLinked = true;
                    try {
                        ValueLink.this.linkedValue.set(ValueLink.this.originalValue.get());
                    }
                    catch (RuntimeException e) {
                        ValueLink.this.originalValue.set(ValueLink.this.linkedValue.get());
                        throw e;
                    }
                }
                finally {
                    ValueLink.this.updatingLinked = false;
                }
            }
        }
    }

    private final class UpdateOriginalValue
    implements Runnable {
        private UpdateOriginalValue() {
        }

        @Override
        public void run() {
            this.updateOriginalValue();
        }

        private void updateOriginalValue() {
            if (!ValueLink.this.updatingLinked) {
                try {
                    ValueLink.this.updatingOriginal = true;
                    try {
                        ValueLink.this.originalValue.set(ValueLink.this.linkedValue.get());
                    }
                    catch (RuntimeException e) {
                        ValueLink.this.linkedValue.set(ValueLink.this.originalValue.get());
                        throw e;
                    }
                }
                finally {
                    ValueLink.this.updatingOriginal = false;
                }
            }
        }
    }

    private static final class LinkedValidator<T>
    implements Value.Validator<T> {
        private final Value<T> linkedValue;
        private Value.Validator<T> excluded;

        private LinkedValidator(Value<T> linkedValue) {
            this.linkedValue = linkedValue;
        }

        @Override
        public void validate(T value) {
            if (this.linkedValue instanceof AbstractValue) {
                ((AbstractValue)this.linkedValue).validators().stream().filter(validator -> validator != this.excluded).forEach(validator -> validator.validate(value));
            }
        }
    }
}

