/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.proxy;

import is.codion.common.proxy.ProxyBuilder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class DefaultProxyBuilder<T>
implements ProxyBuilder<T> {
    private final Map<MethodKey, ProxyBuilder.ProxyMethod<T>> methodMap = new HashMap<MethodKey, ProxyBuilder.ProxyMethod<T>>();
    private final Class<T> interfaceToProxy;
    private T delegate;

    DefaultProxyBuilder(Class<T> interfaceToProxy) {
        if (!Objects.requireNonNull(interfaceToProxy).isInterface()) {
            throw new IllegalArgumentException(interfaceToProxy + " is not an interface");
        }
        this.interfaceToProxy = interfaceToProxy;
    }

    @Override
    public ProxyBuilder<T> delegate(T delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        return this;
    }

    @Override
    public ProxyBuilder<T> method(String methodName, ProxyBuilder.ProxyMethod<T> proxyMethod) {
        return this.method(methodName, Collections.emptyList(), proxyMethod);
    }

    @Override
    public ProxyBuilder<T> method(String methodName, Class<?> parameterType, ProxyBuilder.ProxyMethod<T> proxyMethod) {
        return this.method(methodName, Collections.singletonList(Objects.requireNonNull(parameterType)), proxyMethod);
    }

    @Override
    public ProxyBuilder<T> method(String methodName, List<Class<?>> parameterTypes, ProxyBuilder.ProxyMethod<T> proxyMethod) {
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(parameterTypes);
        Objects.requireNonNull(proxyMethod);
        try {
            this.methodMap.put(DefaultProxyBuilder.findMethod(Collections.singletonList(this.interfaceToProxy), methodName, parameterTypes), proxyMethod);
            return this;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T build() {
        return (T)Proxy.newProxyInstance(this.interfaceToProxy.getClassLoader(), new Class[]{this.interfaceToProxy}, new DefaultHandler<T>(this.methodMap, this.delegate));
    }

    private static MethodKey findMethod(List<Class<?>> interfaces, String methodName, List<Class<?>> parameterTypes) throws NoSuchMethodException {
        Method method = null;
        for (Class<?> anInterface : interfaces) {
            try {
                method = anInterface.getMethod(methodName, parameterTypes.toArray(new Class[0]));
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (method != null) {
            return new MethodKey(method);
        }
        List<Class<?>> superInterfaces = interfaces.stream().flatMap(new GetSuperInterfaces()).collect(Collectors.toList());
        if (superInterfaces.isEmpty()) {
            return new MethodKey(Object.class.getMethod(methodName, parameterTypes.toArray(new Class[0])));
        }
        return DefaultProxyBuilder.findMethod(superInterfaces, methodName, parameterTypes);
    }

    private static final class MethodKey {
        private final String methodName;
        private final Class<?>[] parameterTypes;

        private MethodKey(Method method) {
            this.methodName = method.getName();
            this.parameterTypes = method.getParameterTypes();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            MethodKey methodKey = (MethodKey)object;
            return this.methodName.equals(methodKey.methodName) && Arrays.equals(this.parameterTypes, methodKey.parameterTypes);
        }

        public int hashCode() {
            int result = this.methodName.hashCode();
            result = 31 * result + Arrays.hashCode(this.parameterTypes);
            return result;
        }
    }

    private static final class DefaultHandler<T>
    implements InvocationHandler {
        private static final String EQUALS = "equals";
        private final Map<MethodKey, ProxyBuilder.ProxyMethod<T>> methodMap;
        private final T delegate;

        private DefaultHandler(Map<MethodKey, ProxyBuilder.ProxyMethod<T>> methodMap, T delegate) {
            this.methodMap = methodMap;
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ProxyBuilder.ProxyMethod<Object> proxyMethod = this.methodMap.get(new MethodKey(method));
            if (proxyMethod != null) {
                return proxyMethod.invoke(new DefaultProxyMethodParameters<Object>(proxy, this.delegate, args));
            }
            if (DefaultHandler.isEqualsMethod(method)) {
                return proxy == args[0];
            }
            if (this.delegate != null) {
                return method.invoke(this.delegate, args);
            }
            throw new UnsupportedOperationException(method.toString());
        }

        private static boolean isEqualsMethod(Method method) {
            return EQUALS.equals(method.getName()) && method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(Object.class);
        }
    }

    private static final class GetSuperInterfaces
    implements Function<Class<?>, Stream<Class<?>>> {
        private GetSuperInterfaces() {
        }

        @Override
        public Stream<Class<?>> apply(Class<?> anInterface) {
            return Arrays.stream(anInterface.getInterfaces());
        }
    }

    private static final class DefaultProxyMethodParameters<T>
    implements ProxyBuilder.ProxyMethod.Parameters<T> {
        private final T proxy;
        private final T delegate;
        private final List<?> arguments;

        private DefaultProxyMethodParameters(T proxy, T delegate, Object[] arguments) {
            this.proxy = Objects.requireNonNull(proxy);
            this.delegate = delegate;
            this.arguments = arguments == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(arguments));
        }

        @Override
        public T proxy() {
            return this.proxy;
        }

        @Override
        public T delegate() {
            if (this.delegate == null) {
                throw new IllegalStateException("No delegate specified for proxy");
            }
            return this.delegate;
        }

        @Override
        public List<?> arguments() {
            return this.arguments;
        }
    }
}

