/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.property;

import is.codion.common.property.PropertyStore;
import is.codion.common.property.PropertyValue;
import is.codion.common.value.AbstractValue;
import is.codion.common.value.Value;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;

final class DefaultPropertyStore
implements PropertyStore {
    private static final String VALUE_SEPARATOR = ";";
    private final Map<String, PropertyValue<?>> propertyValues = new HashMap();
    private final Properties properties = new Properties(){

        @Override
        public Enumeration<Object> keys() {
            ArrayList<Object> keys = Collections.list(super.keys());
            keys.sort(Comparator.comparing(Object::toString));
            return Collections.enumeration(keys);
        }
    };

    DefaultPropertyStore(File propertiesFile) throws IOException {
        this(DefaultPropertyStore.loadProperties(propertiesFile));
    }

    DefaultPropertyStore(InputStream inputStream) throws IOException {
        this(DefaultPropertyStore.loadProperties(inputStream));
    }

    DefaultPropertyStore(Properties properties) {
        this.properties.putAll((Map<?, ?>)Objects.requireNonNull(properties, "properties"));
        this.properties.stringPropertyNames().forEach(property -> System.setProperty(property, this.properties.getProperty((String)property)));
    }

    @Override
    public PropertyValue<Boolean> booleanValue(String propertyName) {
        return this.value(propertyName, value -> value.equalsIgnoreCase(Boolean.TRUE.toString()), Objects::toString);
    }

    @Override
    public PropertyValue<Boolean> booleanValue(String propertyName, boolean defaultValue) {
        return this.value(propertyName, value -> value.equalsIgnoreCase(Boolean.TRUE.toString()), Objects::toString, defaultValue);
    }

    @Override
    public PropertyValue<Double> doubleValue(String propertyName) {
        return this.value(propertyName, Double::parseDouble, Objects::toString);
    }

    @Override
    public PropertyValue<Double> doubleValue(String propertyName, double defaultValue) {
        return this.value(propertyName, Double::parseDouble, Objects::toString, defaultValue);
    }

    @Override
    public PropertyValue<Integer> integerValue(String propertyName) {
        return this.value(propertyName, Integer::parseInt, Objects::toString);
    }

    @Override
    public PropertyValue<Integer> integerValue(String propertyName, int defaultValue) {
        return this.value(propertyName, Integer::parseInt, Objects::toString, defaultValue);
    }

    @Override
    public PropertyValue<Long> longValue(String propertyName) {
        return this.value(propertyName, Long::parseLong, Objects::toString);
    }

    @Override
    public PropertyValue<Long> longValue(String propertyName, long defaultValue) {
        return this.value(propertyName, Long::parseLong, Objects::toString, defaultValue);
    }

    @Override
    public PropertyValue<Character> characterValue(String propertyName) {
        return this.value(propertyName, string -> Character.valueOf(string.charAt(0)), Object::toString);
    }

    @Override
    public PropertyValue<Character> characterValue(String propertyName, char defaultValue) {
        return this.value(propertyName, string -> Character.valueOf(string.charAt(0)), Object::toString, Character.valueOf(defaultValue));
    }

    @Override
    public PropertyValue<String> stringValue(String propertyName) {
        return this.stringValue(propertyName, null);
    }

    @Override
    public PropertyValue<String> stringValue(String propertyName, String defaultValue) {
        return this.value(propertyName, Objects::toString, Objects::toString, defaultValue);
    }

    @Override
    public <T extends Enum<T>> PropertyValue<T> enumValue(String propertyName, Class<T> enumClass) {
        return this.enumValue(propertyName, enumClass, null);
    }

    @Override
    public <T extends Enum<T>> PropertyValue<T> enumValue(String propertyName, Class<T> enumClass, T defaultValue) {
        Objects.requireNonNull(enumClass);
        return this.value(propertyName, value -> Enum.valueOf(enumClass, value.toUpperCase()), Objects::toString, defaultValue);
    }

    @Override
    public <T> PropertyValue<List<T>> listValue(String propertyName, Function<String, T> decoder, Function<T, String> encoder) {
        return this.listValue(propertyName, decoder, encoder, Collections.emptyList());
    }

    @Override
    public <T> PropertyValue<List<T>> listValue(String propertyName, Function<String, T> decoder, Function<T, String> encoder, List<T> defaultValue) {
        return this.value(propertyName, new ListValueDecoder<T>(decoder), new ListValueEncoder<T>(encoder), defaultValue);
    }

    @Override
    public <T> PropertyValue<T> value(String propertyName, Function<String, T> decoder, Function<T, String> encoder) {
        return this.value(propertyName, decoder, encoder, null);
    }

    @Override
    public <T> PropertyValue<T> value(String propertyName, Function<String, T> decoder, Function<T, String> encoder, T defaultValue) {
        if (this.propertyValues.containsKey(Objects.requireNonNull(propertyName))) {
            throw new IllegalStateException("A value has already been created for the property '" + propertyName + "'");
        }
        DefaultPropertyValue<T> value = new DefaultPropertyValue<T>(propertyName, decoder, encoder, defaultValue);
        this.propertyValues.put(propertyName, value);
        return value;
    }

    @Override
    public <T> Optional<PropertyValue<T>> propertyValue(String propertyName) {
        return Optional.ofNullable(this.propertyValues.get(Objects.requireNonNull(propertyName)));
    }

    @Override
    public void setProperty(String propertyName, String value) {
        if (this.propertyValues.containsKey(Objects.requireNonNull(propertyName))) {
            throw new IllegalArgumentException("Value bound properties can only be modified through their Value instances");
        }
        this.properties.setProperty(propertyName, value);
    }

    @Override
    public String getProperty(String propertyName) {
        return this.properties.getProperty(Objects.requireNonNull(propertyName));
    }

    @Override
    public Collection<String> properties(String prefix) {
        Objects.requireNonNull(prefix);
        return this.properties.stringPropertyNames().stream().filter(propertyName -> propertyName.startsWith(prefix)).map(this.properties::getProperty).collect(Collectors.toList());
    }

    @Override
    public Collection<String> propertyNames(String prefix) {
        Objects.requireNonNull(prefix);
        return this.properties.stringPropertyNames().stream().filter(propertyName -> propertyName.startsWith(prefix)).collect(Collectors.toList());
    }

    @Override
    public boolean containsProperty(String propertyName) {
        return this.properties.containsKey(Objects.requireNonNull(propertyName));
    }

    @Override
    public void removeAll(String prefix) {
        Collection<String> propertyKeys = this.propertyNames(prefix);
        if (propertyKeys.stream().anyMatch(this.propertyValues::containsKey)) {
            throw new IllegalArgumentException("Value bound properties can only be modified through their Value instances");
        }
        propertyKeys.forEach(this.properties::remove);
    }

    @Override
    public void writeToFile(File propertiesFile) throws IOException {
        Objects.requireNonNull(propertiesFile, "propertiesFile");
        if (!propertiesFile.exists() && !propertiesFile.createNewFile()) {
            throw new IOException("Unable to create properties file: " + propertiesFile);
        }
        try (OutputStream output = Files.newOutputStream(propertiesFile.toPath(), new OpenOption[0]);){
            this.properties.store(output, null);
        }
    }

    private static Properties loadProperties(File propertiesFile) throws IOException {
        if (!Objects.requireNonNull(propertiesFile).exists()) {
            throw new FileNotFoundException(propertiesFile.toString());
        }
        try (InputStream input = Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]);){
            Properties properties = DefaultPropertyStore.loadProperties(input);
            return properties;
        }
    }

    private static Properties loadProperties(InputStream inputStream) throws IOException {
        Objects.requireNonNull(inputStream);
        Properties propertiesFromFile = new Properties();
        propertiesFromFile.load(inputStream);
        return propertiesFromFile;
    }

    private static final class ListValueDecoder<T>
    implements Function<String, List<T>> {
        private final Function<String, T> decoder;

        private ListValueDecoder(Function<String, T> decoder) {
            this.decoder = Objects.requireNonNull(decoder);
        }

        @Override
        public List<T> apply(String stringValue) {
            return stringValue == null ? Collections.emptyList() : Arrays.stream(stringValue.split(DefaultPropertyStore.VALUE_SEPARATOR)).map(this.decoder).collect(Collectors.toList());
        }
    }

    private static final class ListValueEncoder<T>
    implements Function<List<T>, String> {
        private final Function<T, String> encoder;

        private ListValueEncoder(Function<T, String> encoder) {
            this.encoder = Objects.requireNonNull(encoder);
        }

        @Override
        public String apply(List<T> valueList) {
            return valueList.stream().map(this.encoder).collect(Collectors.joining(DefaultPropertyStore.VALUE_SEPARATOR));
        }
    }

    private final class DefaultPropertyValue<T>
    extends AbstractValue<T>
    implements PropertyValue<T> {
        private final String propertyName;
        private final Function<T, String> encoder;
        private T value;

        private DefaultPropertyValue(String propertyName, Function<String, T> decoder, Function<T, String> encoder, T defaultValue) {
            super(defaultValue, Value.Notify.WHEN_CHANGED);
            this.propertyName = Objects.requireNonNull(propertyName);
            this.encoder = Objects.requireNonNull(encoder);
            this.set(this.getInitialValue(propertyName, Objects.requireNonNull(decoder)));
        }

        @Override
        public String propertyName() {
            return this.propertyName;
        }

        @Override
        public T getOrThrow() throws IllegalStateException {
            return this.getOrThrow("Required configuration value is missing: " + this.propertyName);
        }

        @Override
        public T getOrThrow(String message) throws IllegalStateException {
            Objects.requireNonNull(message, "message");
            if (this.value == null) {
                throw new IllegalStateException(message);
            }
            return this.value;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public void clear() {
            boolean wasNotNull = this.value != null;
            this.setValue(null);
            if (wasNotNull) {
                this.notifyListeners();
            }
        }

        public String toString() {
            return this.propertyName;
        }

        @Override
        protected void setValue(T value) {
            this.value = value;
            if (value == null) {
                DefaultPropertyStore.this.properties.remove(this.propertyName);
                System.clearProperty(this.propertyName);
            } else {
                DefaultPropertyStore.this.properties.setProperty(this.propertyName, this.encoder.apply(value));
                System.setProperty(this.propertyName, DefaultPropertyStore.this.properties.getProperty(this.propertyName));
            }
        }

        private T getInitialValue(String property, Function<String, T> decoder) {
            String initialValue = System.getProperty(property);
            if (initialValue == null) {
                initialValue = DefaultPropertyStore.this.properties.getProperty(property);
            }
            return initialValue == null ? null : (T)decoder.apply(initialValue);
        }
    }
}

