/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.item;

import is.codion.common.item.DefaultItem;
import is.codion.common.item.ItemI18n;
import java.io.Serializable;
import java.util.function.Supplier;

public interface Item<T>
extends Supplier<T>,
Comparable<Item<T>>,
Serializable {
    public String caption();

    @Override
    public T get();

    public static <T> Item<T> item(T value) {
        if (value == null) {
            return DefaultItem.NULL_ITEM;
        }
        return Item.item(value, value.toString());
    }

    public static <T> Item<T> item(T value, String caption) {
        return new DefaultItem<T>(value, caption);
    }

    public static <T> Item<T> itemI18n(T value, String resourceBundleName, String resourceBundleKey) {
        return new ItemI18n<T>(value, resourceBundleName, resourceBundleKey);
    }
}

