/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.version;

import is.codion.common.version.DefaultVersion;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;

public interface Version
extends Comparable<Version> {
    public static final String VERSION_PROPERTY_KEY = "version";

    public int major();

    public int minor();

    public int patch();

    public String metadata();

    public static Version version(int major) {
        return Version.version(major, 0);
    }

    public static Version version(int major, int minor) {
        return Version.version(major, minor, 0);
    }

    public static Version version(int major, int minor, int patch) {
        return Version.version(major, minor, patch, null);
    }

    public static Version version(int major, int minor, int patch, String metadata) {
        return new DefaultVersion(major, minor, patch, metadata);
    }

    public static String versionString() {
        String versionString = Version.versionAndMetadataString();
        if (versionString.toLowerCase().contains("-")) {
            return versionString.substring(0, versionString.toLowerCase().indexOf(45));
        }
        return versionString;
    }

    public static String versionAndMetadataString() {
        return DefaultVersion.VERSION.toString();
    }

    public static Version version() {
        return DefaultVersion.VERSION;
    }

    public static Version parse(String versionString) {
        String metadata;
        String version;
        if (versionString == null || versionString.isEmpty()) {
            throw new IllegalArgumentException("Invalid version string: " + versionString);
        }
        int dashIndex = versionString.indexOf(45);
        if (dashIndex > 0) {
            version = versionString.substring(0, dashIndex);
            metadata = versionString.substring(dashIndex + 1);
        } else {
            int spaceIndex = versionString.indexOf(32);
            if (spaceIndex > 0) {
                version = versionString.substring(0, spaceIndex);
                metadata = versionString.substring(spaceIndex + 1);
            } else {
                version = versionString;
                metadata = null;
            }
        }
        String[] versionSplit = version.split("\\.");
        int major = versionSplit.length > 0 ? Integer.parseInt(versionSplit[0]) : 0;
        int minor = versionSplit.length > 1 ? Integer.parseInt(versionSplit[1]) : 0;
        int patch = versionSplit.length > 2 ? Integer.parseInt(versionSplit[2]) : 0;
        return new DefaultVersion(major, minor, patch, metadata);
    }

    public static Version parsePropertiesFile(Class<?> resourceOwner, String resourcePath) {
        Version version;
        block10: {
            InputStream resourceStream = Objects.requireNonNull(resourceOwner).getResourceAsStream(Objects.requireNonNull(resourcePath));
            try {
                if (resourceStream == null) {
                    throw new IllegalArgumentException("Version resource not found: " + resourceOwner + ", " + resourcePath);
                }
                Properties properties = new Properties();
                properties.load(resourceStream);
                String version2 = properties.getProperty(VERSION_PROPERTY_KEY);
                if (version2 == null) {
                    throw new IllegalArgumentException("No 'version' property found: " + resourceOwner + ", " + resourcePath);
                }
                version = Version.parse(version2);
                if (resourceStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceStream != null) {
                        try {
                            resourceStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to parse version information", e);
                }
            }
            resourceStream.close();
        }
        return version;
    }
}

