/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.value;

import is.codion.common.event.Event;
import is.codion.common.value.DefaultValueObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueLink;
import is.codion.common.value.ValueObserver;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractValue<T>
implements Value<T> {
    private final T nullValue;
    private final Value.Notify notify;
    private Event<T> changeEvent;
    private Set<Value.Validator<T>> validators;
    private Map<Value<T>, ValueLink<T>> linkedValues;
    private Consumer<T> originalValueListener;
    private ValueObserver<T> observer;

    protected AbstractValue() {
        this(null);
    }

    protected AbstractValue(T nullValue) {
        this.nullValue = nullValue;
        this.notify = null;
    }

    protected AbstractValue(T nullValue, Value.Notify notify) {
        this.nullValue = nullValue;
        this.notify = Objects.requireNonNull(notify);
    }

    @Override
    public final boolean set(T value) {
        T newValue = value == null ? this.nullValue : value;
        for (Value.Validator<T> validator : this.validators()) {
            validator.validate(newValue);
        }
        Object previousValue = this.get();
        this.setValue(newValue);
        return this.notifyListeners(!Objects.equals(previousValue, newValue));
    }

    @Override
    public final boolean map(Function<T, T> mapper) {
        return this.set(Objects.requireNonNull(mapper).apply(this.get()));
    }

    @Override
    public final synchronized ValueObserver<T> observer() {
        if (this.observer == null) {
            this.observer = new DefaultValueObserver(this);
        }
        return this.observer;
    }

    @Override
    public final boolean nullable() {
        return this.nullValue == null;
    }

    @Override
    public final void accept(T data) {
        this.set(data);
    }

    @Override
    public final boolean addListener(Runnable listener) {
        return this.changeEvent().addListener(listener);
    }

    @Override
    public final boolean removeListener(Runnable listener) {
        if (this.changeEvent != null) {
            return this.changeEvent.removeListener(listener);
        }
        return false;
    }

    @Override
    public final boolean addDataListener(Consumer<? super T> listener) {
        return this.changeEvent().addDataListener(listener);
    }

    @Override
    public final boolean removeDataListener(Consumer<? super T> listener) {
        if (this.changeEvent != null) {
            return this.changeEvent.removeDataListener(listener);
        }
        return false;
    }

    @Override
    public final boolean addWeakListener(Runnable listener) {
        return this.changeEvent().addWeakListener(listener);
    }

    @Override
    public final boolean removeWeakListener(Runnable listener) {
        if (this.changeEvent != null) {
            return this.changeEvent.removeWeakListener(listener);
        }
        return false;
    }

    @Override
    public final boolean addWeakDataListener(Consumer<? super T> listener) {
        return this.changeEvent().addWeakDataListener(listener);
    }

    @Override
    public final boolean removeWeakDataListener(Consumer<? super T> listener) {
        if (this.changeEvent != null) {
            return this.changeEvent.removeWeakDataListener(listener);
        }
        return false;
    }

    @Override
    public final void link(Value<T> originalValue) {
        Objects.requireNonNull(originalValue);
        if (this.linkedValues == null) {
            this.linkedValues = new LinkedHashMap<Value<T>, ValueLink<T>>(1);
        }
        if (this.linkedValues.containsKey(originalValue)) {
            throw new IllegalStateException("Values are already linked");
        }
        this.linkedValues.put(originalValue, new ValueLink<T>(this, originalValue));
    }

    @Override
    public final void unlink(Value<T> originalValue) {
        Objects.requireNonNull(originalValue);
        if (this.linkedValues != null) {
            if (!this.linkedValues.containsKey(originalValue)) {
                throw new IllegalStateException("Values are not linked");
            }
            this.linkedValues.remove(originalValue).unlink();
        }
    }

    @Override
    public final void link(ValueObserver<T> originalValue) {
        Objects.requireNonNull(originalValue);
        if (this.originalValueListener == null) {
            this.originalValueListener = new OriginalValueListener();
        }
        this.set(originalValue.get());
        originalValue.addDataListener(this.originalValueListener);
    }

    @Override
    public final void unlink(ValueObserver<T> originalValue) {
        Objects.requireNonNull(originalValue);
        if (this.originalValueListener != null) {
            originalValue.removeDataListener(this.originalValueListener);
        }
    }

    @Override
    public final boolean addValidator(Value.Validator<T> validator) {
        Objects.requireNonNull(validator, "validator").validate(this.get());
        if (this.validators == null) {
            this.validators = new LinkedHashSet<Value.Validator<T>>(1);
        }
        return this.validators.add(validator);
    }

    @Override
    public final boolean removeValidator(Value.Validator<T> validator) {
        Objects.requireNonNull(validator, "validator");
        if (this.validators != null) {
            return this.validators.remove(validator);
        }
        return false;
    }

    @Override
    public final void validate(T value) {
        this.validators().forEach(validator -> validator.validate(value));
    }

    protected abstract void setValue(T var1);

    protected final void notifyListeners() {
        if (this.changeEvent != null) {
            this.changeEvent.accept(this.get());
        }
    }

    final Set<Value<T>> linkedValues() {
        return this.linkedValues == null ? Collections.emptySet() : this.linkedValues.keySet();
    }

    final Collection<Value.Validator<T>> validators() {
        return this.validators == null ? Collections.emptyList() : this.validators;
    }

    private boolean notifyListeners(boolean changed) {
        if (this.notify == Value.Notify.WHEN_SET || this.notify == Value.Notify.WHEN_CHANGED && changed) {
            this.notifyListeners();
        }
        return changed;
    }

    private synchronized Event<T> changeEvent() {
        if (this.changeEvent == null) {
            this.changeEvent = Event.event();
        }
        return this.changeEvent;
    }

    private final class OriginalValueListener
    implements Consumer<T> {
        private OriginalValueListener() {
        }

        @Override
        public void accept(T value) {
            AbstractValue.this.set(value);
        }
    }
}

