/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.user;

import is.codion.common.user.User;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

final class DefaultUser
implements User,
Serializable {
    private static final long serialVersionUID = 1L;
    private String username;
    private char[] password;

    DefaultUser(String username, char[] password) {
        if (Objects.requireNonNull(username, "username").isEmpty()) {
            throw new IllegalArgumentException("Username must be non-empty");
        }
        this.username = username;
        this.setPassword(password);
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public char[] password() {
        return Arrays.copyOf(this.password, this.password.length);
    }

    @Override
    public User clearPassword() {
        Arrays.fill(this.password, '\u0000');
        this.setPassword(null);
        return this;
    }

    @Override
    public User copy() {
        return new DefaultUser(this.username, this.password());
    }

    public String toString() {
        return "User: " + this.username;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof User && ((User)obj).username().equalsIgnoreCase(this.username);
    }

    public int hashCode() {
        return this.username.hashCode();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.username);
        stream.writeObject(this.password);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.username = (String)stream.readObject();
        this.setPassword((char[])stream.readObject());
    }

    private void setPassword(char[] password) {
        this.password = password == null ? new char[]{} : Arrays.copyOf(password, password.length);
    }
}

