/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.logging;

import is.codion.common.logging.DefaultMethodLogger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public interface MethodLogger {
    public void enter(String var1);

    public void enter(String var1, Object var2);

    public Entry exit(String var1);

    public Entry exit(String var1, Throwable var2);

    public Entry exit(String var1, Throwable var2, String var3);

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public List<Entry> entries();

    public static MethodLogger methodLogger(int maxSize) {
        return MethodLogger.methodLogger(maxSize, new DefaultArgumentToString());
    }

    public static MethodLogger methodLogger(int maxSize, ArgumentToString argumentStringProvider) {
        return new DefaultMethodLogger(maxSize, argumentStringProvider);
    }

    public static class DefaultArgumentToString
    implements ArgumentToString {
        private static final String BRACKET_OPEN = "[";
        private static final String BRACKET_CLOSE = "]";

        @Override
        public final String argumentToString(String methodName, Object object) {
            return this.toString(methodName, object);
        }

        protected String toString(String methodName, Object object) {
            return this.toString(object);
        }

        protected String toString(Object object) {
            if (object == null) {
                return "";
            }
            if (object instanceof List) {
                return this.toString((List)object);
            }
            if (object instanceof Collection) {
                return this.toString((Collection)object);
            }
            if (object instanceof byte[]) {
                return "byte[" + ((byte[])object).length + BRACKET_CLOSE;
            }
            if (object.getClass().isArray()) {
                return this.toString((Object[])object);
            }
            return object.toString();
        }

        private String toString(List<?> arguments) {
            if (arguments.isEmpty()) {
                return "";
            }
            if (arguments.size() == 1) {
                return this.toString(arguments.get(0));
            }
            return arguments.stream().map(this::toString).collect(Collectors.joining(", ", BRACKET_OPEN, BRACKET_CLOSE));
        }

        private String toString(Collection<?> arguments) {
            if (arguments.isEmpty()) {
                return "";
            }
            return arguments.stream().map(this::toString).collect(Collectors.joining(", ", BRACKET_OPEN, BRACKET_CLOSE));
        }

        private String toString(Object[] arguments) {
            if (arguments.length == 0) {
                return "";
            }
            if (arguments.length == 1) {
                return this.toString(arguments[0]);
            }
            return Arrays.stream(arguments).map(this::toString).collect(Collectors.joining(", ", BRACKET_OPEN, BRACKET_CLOSE));
        }
    }

    public static interface ArgumentToString {
        public String argumentToString(String var1, Object var2);
    }

    public static interface Entry {
        public boolean hasChildEntries();

        public List<Entry> childEntries();

        public String method();

        public String enterMessage();

        public long duration();

        public void appendTo(StringBuilder var1);

        public String toString(int var1);
    }
}

