/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common;

import is.codion.common.Configuration;
import is.codion.common.NullOrEmpty;
import is.codion.common.Separators;
import is.codion.common.property.PropertyValue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class Text {
    public static final PropertyValue<String> DEFAULT_COLLATOR_LANGUAGE = Configuration.stringValue("codion.defaultCollatorLanguage", Locale.getDefault().getLanguage());
    public static final PropertyValue<Character> WILDCARD_CHARACTER = Configuration.characterValue("codion.wildcardCharacter", '%');
    private static final Random RANDOM = new Random();
    private static final char SPACE = ' ';
    private static final char UNDERSCORE = '_';
    private static final String ALPHA_NUMERIC = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    private Text() {
    }

    public static String randomString(int minimumLength, int maximumLength) {
        if (minimumLength > maximumLength) {
            throw new IllegalArgumentException("Minimum length can not exceed maximum length");
        }
        int length = minimumLength == maximumLength ? minimumLength : RANDOM.nextInt(maximumLength - minimumLength) + minimumLength;
        return IntStream.range(0, length).mapToObj(i -> String.valueOf(ALPHA_NUMERIC.charAt(RANDOM.nextInt(ALPHA_NUMERIC.length())))).collect(Collectors.joining());
    }

    public static <T> List<T> collate(List<T> values) {
        Objects.requireNonNull(values).sort(Text.collator());
        return values;
    }

    public static <T> Comparator<T> collator() {
        return Text.collator(new Locale((String)DEFAULT_COLLATOR_LANGUAGE.get()));
    }

    public static <T> Comparator<T> collator(Locale locale) {
        return new SpaceAwareComparator(Objects.requireNonNull(locale));
    }

    public static String rightPad(String string, int length, char padChar) {
        return Text.padString(string, length, padChar, false);
    }

    public static String leftPad(String string, int length, char padChar) {
        return Text.padString(string, length, padChar, true);
    }

    public static String delimitedString(List<String> header, List<List<String>> lines, String columnDelimiter) {
        Objects.requireNonNull(header, "header");
        Objects.requireNonNull(lines, "lines");
        Objects.requireNonNull(columnDelimiter, "delimiter");
        StringBuilder contents = new StringBuilder();
        contents.append(String.join((CharSequence)columnDelimiter, header)).append(Separators.LINE_SEPARATOR).append(lines.stream().map(line -> String.join((CharSequence)columnDelimiter, line)).collect(Collectors.joining(Separators.LINE_SEPARATOR)));
        return contents.toString();
    }

    public static <T> String textFileContents(Class<T> resourceClass, String resourceName) throws IOException {
        return Text.textFileContents(resourceClass, resourceName, Charset.defaultCharset());
    }

    public static <T> String textFileContents(Class<T> resourceClass, String resourceName, Charset charset) throws IOException {
        Objects.requireNonNull(resourceClass, "resourceClass");
        Objects.requireNonNull(resourceName, "resourceName");
        InputStream inputStream = resourceClass.getResourceAsStream(resourceName);
        if (inputStream == null) {
            throw new FileNotFoundException("Resource not found: '" + resourceName + "'");
        }
        return Text.textFileContents(inputStream, charset);
    }

    public static String textFileContents(String filename, Charset charset) throws IOException {
        Objects.requireNonNull(filename, "filename");
        return Text.textFileContents(new File(filename), charset);
    }

    public static String textFileContents(File file, Charset charset) throws IOException {
        Objects.requireNonNull(file, "file");
        try (FileInputStream inputStream = new FileInputStream(file);){
            String string = Text.textFileContents(inputStream, charset);
            return string;
        }
    }

    public static String textFileContents(InputStream inputStream, Charset charset) throws IOException {
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(charset, "charset");
        StringBuilder contents = new StringBuilder();
        try (BufferedReader input = new BufferedReader(new InputStreamReader(inputStream, charset));){
            String line = input.readLine();
            while (line != null) {
                contents.append(line);
                line = input.readLine();
                if (line == null) continue;
                contents.append(Separators.LINE_SEPARATOR);
            }
        }
        return contents.toString();
    }

    public static List<String> parseCommaSeparatedValues(String commaSeparatedValues) {
        if (NullOrEmpty.nullOrEmpty(commaSeparatedValues)) {
            return Collections.emptyList();
        }
        return Arrays.stream(commaSeparatedValues.split(",")).map(String::trim).filter(string -> !string.isEmpty()).collect(Collectors.toList());
    }

    public static String underscoreToCamelCase(String text) {
        if (!Objects.requireNonNull(text, "text").contains("_")) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        boolean firstDone = false;
        List strings = Arrays.stream(text.toLowerCase().split("_")).filter(string -> !string.isEmpty()).collect(Collectors.toList());
        if (strings.size() == 1) {
            return (String)strings.get(0);
        }
        for (String split : strings) {
            if (!firstDone) {
                builder.append(Character.toLowerCase(split.charAt(0)));
                firstDone = true;
            } else {
                builder.append(Character.toUpperCase(split.charAt(0)));
            }
            if (split.length() <= 1) continue;
            builder.append(split.substring(1).toLowerCase());
        }
        return builder.toString();
    }

    private static String padString(String string, int length, char padChar, boolean left) {
        if (Objects.requireNonNull(string, "string").length() >= length) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        while (stringBuilder.length() < length) {
            if (left) {
                stringBuilder.insert(0, padChar);
                continue;
            }
            stringBuilder.append(padChar);
        }
        return stringBuilder.toString();
    }

    private static final class SpaceAwareComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Locale locale;
        private transient Collator collator;

        private SpaceAwareComparator(Locale locale) {
            this.locale = locale;
        }

        @Override
        public int compare(T o1, T o2) {
            return this.collator().compare(o1.toString().replace(' ', '_'), o2.toString().replace(' ', '_'));
        }

        private Collator collator() {
            if (this.collator == null) {
                this.collator = Collator.getInstance(this.locale);
            }
            return this.collator;
        }
    }
}

