/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.state;

import is.codion.common.Conjunction;
import is.codion.common.state.DefaultStateObserver;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

final class DefaultStateCombination
implements State.Combination {
    private final DefaultStateObserver observer;
    private final List<StateCombinationListener> stateListeners = new ArrayList<StateCombinationListener>();
    private final Conjunction conjunction;

    DefaultStateCombination(Conjunction conjunction, StateObserver ... states) {
        this(conjunction, states == null ? Collections.emptyList() : Arrays.asList(states));
    }

    DefaultStateCombination(Conjunction conjunction, Collection<? extends StateObserver> states) {
        this.observer = new DefaultStateObserver(this, false);
        this.conjunction = Objects.requireNonNull(conjunction);
        for (StateObserver stateObserver : Objects.requireNonNull(states)) {
            this.add(stateObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        DefaultStateObserver defaultStateObserver = this.observer;
        synchronized (defaultStateObserver) {
            StringBuilder stringBuilder = new StringBuilder("Combination");
            stringBuilder.append(DefaultStateCombination.toString(this.conjunction)).append(this.observer);
            for (StateCombinationListener listener : this.stateListeners) {
                stringBuilder.append(", ").append(listener.state);
            }
            return stringBuilder.toString();
        }
    }

    @Override
    public Conjunction conjunction() {
        return this.conjunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(StateObserver state) {
        Objects.requireNonNull(state, "state");
        DefaultStateObserver defaultStateObserver = this.observer;
        synchronized (defaultStateObserver) {
            if (!this.findListener(state).isPresent()) {
                boolean previousValue = this.get();
                this.stateListeners.add(new StateCombinationListener(state));
                this.observer.notifyObservers(this.get(), previousValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(StateObserver state) {
        Objects.requireNonNull(state, "state");
        DefaultStateObserver defaultStateObserver = this.observer;
        synchronized (defaultStateObserver) {
            boolean previousValue = this.get();
            this.findListener(state).ifPresent(listener -> {
                state.removeDataListener(listener);
                this.stateListeners.remove(listener);
                this.observer.notifyObservers(this.get(), previousValue);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean get() {
        DefaultStateObserver defaultStateObserver = this.observer;
        synchronized (defaultStateObserver) {
            return this.get(this.conjunction, null, false);
        }
    }

    @Override
    public boolean isNull() {
        return this.observer.isNull();
    }

    @Override
    public boolean isNotNull() {
        return this.observer.isNotNull();
    }

    @Override
    public boolean nullable() {
        return this.observer.nullable();
    }

    @Override
    public StateObserver not() {
        return this.observer.not();
    }

    @Override
    public boolean addListener(Runnable listener) {
        return this.observer.addListener(listener);
    }

    @Override
    public boolean removeListener(Runnable listener) {
        return this.observer.removeListener(listener);
    }

    @Override
    public boolean addDataListener(Consumer<? super Boolean> listener) {
        return this.observer.addDataListener(listener);
    }

    @Override
    public boolean removeDataListener(Consumer<? super Boolean> listener) {
        return this.observer.removeDataListener(listener);
    }

    @Override
    public boolean addWeakListener(Runnable listener) {
        return this.observer.addWeakListener(listener);
    }

    @Override
    public boolean removeWeakListener(Runnable listener) {
        return this.observer.removeWeakListener(listener);
    }

    @Override
    public boolean addWeakDataListener(Consumer<? super Boolean> listener) {
        return this.observer.addWeakDataListener(listener);
    }

    @Override
    public boolean removeWeakDataListener(Consumer<? super Boolean> listener) {
        return this.observer.removeWeakDataListener(listener);
    }

    private boolean get(Conjunction conjunction, StateObserver exclude, boolean excludeReplacement) {
        for (StateCombinationListener listener : this.stateListeners) {
            boolean value;
            StateObserver state = listener.state;
            boolean bl = value = state.equals(exclude) ? excludeReplacement : (Boolean)state.get();
            if (conjunction == Conjunction.AND) {
                if (value) continue;
                return false;
            }
            if (!value) continue;
            return true;
        }
        return conjunction == Conjunction.AND;
    }

    private Optional<StateCombinationListener> findListener(StateObserver state) {
        return this.stateListeners.stream().filter(listener -> listener.state.equals(state)).findFirst();
    }

    private static String toString(Conjunction conjunction) {
        switch (conjunction) {
            case AND: {
                return " and ";
            }
            case OR: {
                return " or ";
            }
        }
        throw new IllegalArgumentException("Unknown conjunction: " + conjunction);
    }

    private final class StateCombinationListener
    implements Consumer<Boolean> {
        private final StateObserver state;

        private StateCombinationListener(StateObserver state) {
            this.state = state;
            this.state.addDataListener(this);
        }

        @Override
        public void accept(Boolean newValue) {
            DefaultStateCombination.this.observer.notifyObservers(DefaultStateCombination.this.get(), this.previousState(this.state, newValue == false));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean previousState(StateObserver excludeState, boolean previousValue) {
            DefaultStateObserver defaultStateObserver = DefaultStateCombination.this.observer;
            synchronized (defaultStateObserver) {
                return DefaultStateCombination.this.get(DefaultStateCombination.this.conjunction, excludeState, previousValue);
            }
        }
    }
}

