/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.logging;

import is.codion.common.NullOrEmpty;
import is.codion.common.Text;
import is.codion.common.logging.MethodLogger;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

final class DefaultMethodLogger
implements MethodLogger {
    private final Deque<DefaultEntry> callStack = new LinkedList<DefaultEntry>();
    private final LinkedList<MethodLogger.Entry> entries = new LinkedList();
    private final MethodLogger.ArgumentToString argumentToString;
    private final int maxSize;
    private boolean enabled = false;

    DefaultMethodLogger(int maxSize, MethodLogger.ArgumentToString argumentToString) {
        this.maxSize = maxSize;
        this.argumentToString = Objects.requireNonNull(argumentToString, "argumentStringProvider");
    }

    @Override
    public synchronized void enter(String method) {
        if (this.enabled) {
            this.callStack.push(new DefaultEntry(method, null));
        }
    }

    @Override
    public synchronized void enter(String method, Object argument) {
        if (this.enabled) {
            this.callStack.push(new DefaultEntry(method, this.argumentToString.argumentToString(method, argument)));
        }
    }

    @Override
    public MethodLogger.Entry exit(String method) {
        return this.exit(method, null);
    }

    @Override
    public MethodLogger.Entry exit(String method, Throwable exception) {
        return this.exit(method, exception, null);
    }

    @Override
    public synchronized MethodLogger.Entry exit(String method, Throwable exception, String exitMessage) {
        if (!this.enabled) {
            return null;
        }
        if (this.callStack.isEmpty()) {
            throw new IllegalStateException("Call stack is empty when trying to log method exit: " + method);
        }
        DefaultEntry entry = this.callStack.pop();
        if (!entry.method().equals(method)) {
            throw new IllegalStateException("Expecting method " + entry.method() + " but got " + method + " when trying to log method exit");
        }
        entry.setExitTime();
        entry.setException(exception);
        entry.setExitMessage(exitMessage);
        if (this.callStack.isEmpty()) {
            if (this.entries.size() == this.maxSize) {
                this.entries.removeFirst();
            }
            this.entries.addLast(entry);
        } else {
            this.callStack.peek().addChildEntry(entry);
        }
        return entry;
    }

    @Override
    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public synchronized void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            if (!enabled) {
                this.entries.clear();
                this.callStack.clear();
            }
        }
    }

    @Override
    public synchronized List<MethodLogger.Entry> entries() {
        return Collections.unmodifiableList(this.entries);
    }

    private static final class DefaultEntry
    implements MethodLogger.Entry,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        private static final NumberFormat MICROSECONDS_FORMAT = NumberFormat.getIntegerInstance();
        private static final String NEWLINE = "\n";
        private static final int INDENTATION_CHARACTERS = 11;
        private final LinkedList<MethodLogger.Entry> childEntries = new LinkedList();
        private final String method;
        private final String enterMessage;
        private final long enterTime;
        private final long enterTimeNano;
        private String exitMessage;
        private long exitTime;
        private long exitTimeNano;
        private String stackTrace;

        private DefaultEntry(String method, String enterMessage) {
            this(method, enterMessage, System.currentTimeMillis(), System.nanoTime());
        }

        private DefaultEntry(String method, String enterMessage, long enterTime, long enterTimeNano) {
            this.method = method;
            this.enterTime = enterTime;
            this.enterTimeNano = enterTimeNano;
            this.enterMessage = enterMessage;
        }

        @Override
        public boolean hasChildEntries() {
            return !this.childEntries.isEmpty();
        }

        @Override
        public List<MethodLogger.Entry> childEntries() {
            return Collections.unmodifiableList(this.childEntries);
        }

        @Override
        public String method() {
            return this.method;
        }

        @Override
        public String enterMessage() {
            return this.enterMessage;
        }

        @Override
        public long duration() {
            return this.exitTimeNano - this.enterTimeNano;
        }

        @Override
        public void appendTo(StringBuilder builder) {
            Objects.requireNonNull(builder).append(this).append(NEWLINE);
            DefaultEntry.appendLogEntries(builder, this.childEntries(), 1);
        }

        public String toString() {
            return this.toString(0);
        }

        @Override
        public String toString(int indentation) {
            LocalDateTime enterDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.enterTime), TimeZone.getDefault().toZoneId());
            String indentString = indentation > 0 ? Text.rightPad("", indentation * 11, ' ') : "";
            StringBuilder stringBuilder = new StringBuilder(indentString).append(TIMESTAMP_FORMATTER.format(enterDateTime)).append(" @ ");
            int timestampLength = stringBuilder.length();
            stringBuilder.append(this.method);
            String padString = Text.rightPad("", timestampLength, ' ');
            if (!NullOrEmpty.nullOrEmpty(this.enterMessage)) {
                if (DefaultEntry.multiLine(this.enterMessage)) {
                    stringBuilder.append(NEWLINE).append(padString).append(this.enterMessage.replace(NEWLINE, NEWLINE + padString));
                } else {
                    stringBuilder.append(": ").append(this.enterMessage);
                }
            }
            if (this.exitTime != 0L) {
                LocalDateTime exitDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.exitTime), TimeZone.getDefault().toZoneId());
                stringBuilder.append(NEWLINE).append(indentString).append(TIMESTAMP_FORMATTER.format(exitDateTime)).append(" > ").append(MICROSECONDS_FORMAT.format(TimeUnit.NANOSECONDS.toMicros(this.duration()))).append(" \u03bcs").append((String)(this.exitMessage == null ? "" : " (" + this.exitMessage + ")"));
                if (this.stackTrace != null) {
                    stringBuilder.append(NEWLINE).append(padString).append(this.stackTrace.replace(NEWLINE, NEWLINE + padString));
                }
            }
            return stringBuilder.toString();
        }

        private void addChildEntry(MethodLogger.Entry childEntry) {
            this.childEntries.addLast(childEntry);
        }

        private void setExitTime() {
            this.exitTime = System.currentTimeMillis();
            this.exitTimeNano = System.nanoTime();
        }

        private void setException(Throwable exception) {
            if (exception != null) {
                this.stackTrace = DefaultEntry.stackTrace(exception);
            }
        }

        private void setExitMessage(String exitMessage) {
            this.exitMessage = exitMessage;
        }

        private static void appendLogEntries(StringBuilder log, List<MethodLogger.Entry> entries, int indentationLevel) {
            for (MethodLogger.Entry entry : entries) {
                log.append(entry.toString(indentationLevel)).append(NEWLINE);
                DefaultEntry.appendLogEntries(log, entry.childEntries(), indentationLevel + 1);
            }
        }

        private static String stackTrace(Throwable exception) {
            StringWriter writer = new StringWriter();
            exception.printStackTrace(new PrintWriter(writer));
            return writer.toString();
        }

        private static boolean multiLine(String enterMessage) {
            return enterMessage.contains(NEWLINE);
        }
    }
}

