/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.event;

import is.codion.common.event.EventObserver;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

final class DefaultEventObserver<T>
implements EventObserver<T> {
    private static final String LISTENER = "listener";
    private final Object lock = new Object();
    private Set<Runnable> listeners;
    private Set<Consumer<T>> dataListeners;
    private List<WeakReference<Runnable>> weakListeners;
    private List<WeakReference<Consumer<T>>> weakDataListeners;

    DefaultEventObserver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addDataListener(Consumer<T> listener) {
        Objects.requireNonNull(listener, LISTENER);
        Object object = this.lock;
        synchronized (object) {
            return this.initDataListeners().add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeDataListener(Consumer<T> listener) {
        Objects.requireNonNull(listener, LISTENER);
        Object object = this.lock;
        synchronized (object) {
            return this.initDataListeners().remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addListener(Runnable listener) {
        Objects.requireNonNull(listener, LISTENER);
        Object object = this.lock;
        synchronized (object) {
            return this.initListeners().add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(Runnable listener) {
        Objects.requireNonNull(listener, LISTENER);
        Object object = this.lock;
        synchronized (object) {
            return this.initListeners().remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addWeakListener(Runnable listener) {
        Objects.requireNonNull(listener, LISTENER);
        Object object = this.lock;
        synchronized (object) {
            List<WeakReference<Runnable>> references = this.initWeakListeners();
            for (WeakReference<Runnable> reference : references) {
                if (reference.get() != listener) continue;
                return false;
            }
            return references.add(new WeakReference<Runnable>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeWeakListener(Runnable listener) {
        Objects.requireNonNull(listener, LISTENER);
        Object object = this.lock;
        synchronized (object) {
            return this.initWeakListeners().removeIf(reference -> reference.get() == null || reference.get() == listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addWeakDataListener(Consumer<T> listener) {
        Objects.requireNonNull(listener, LISTENER);
        Object object = this.lock;
        synchronized (object) {
            List<WeakReference<Consumer<T>>> references = this.initWeakDataListeners();
            for (WeakReference<Consumer<T>> reference : references) {
                if (reference.get() != listener) continue;
                return false;
            }
            return references.add(new WeakReference<Consumer<T>>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeWeakDataListener(Consumer<T> listener) {
        Objects.requireNonNull(listener, LISTENER);
        Object object = this.lock;
        synchronized (object) {
            return this.initWeakDataListeners().removeIf(reference -> reference.get() == null || reference.get() == listener);
        }
    }

    void notifyListeners(T data) {
        for (Runnable runnable : this.listeners()) {
            runnable.run();
        }
        for (Consumer consumer : this.dataListeners()) {
            consumer.accept(data);
        }
        for (WeakReference weakReference : this.weakListeners()) {
            Runnable weakListener = (Runnable)weakReference.get();
            if (weakListener == null) continue;
            weakListener.run();
        }
        for (WeakReference weakReference : this.weakDataListeners()) {
            Consumer weakDataListener = (Consumer)weakReference.get();
            if (weakDataListener == null) continue;
            weakDataListener.accept(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Runnable> listeners() {
        Object object = this.lock;
        synchronized (object) {
            if (this.listeners != null && !this.listeners.isEmpty()) {
                return new ArrayList<Runnable>(this.listeners);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Consumer<T>> dataListeners() {
        Object object = this.lock;
        synchronized (object) {
            if (this.dataListeners != null && !this.dataListeners.isEmpty()) {
                return new ArrayList<Consumer<T>>(this.dataListeners);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WeakReference<Runnable>> weakListeners() {
        Object object = this.lock;
        synchronized (object) {
            if (this.weakListeners != null && !this.weakListeners.isEmpty()) {
                this.weakListeners.removeIf(reference -> reference.get() == null);
                return new ArrayList<WeakReference<Runnable>>(this.weakListeners);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WeakReference<Consumer<T>>> weakDataListeners() {
        Object object = this.lock;
        synchronized (object) {
            if (this.weakDataListeners != null && !this.weakDataListeners.isEmpty()) {
                this.weakDataListeners.removeIf(reference -> reference.get() == null);
                return new ArrayList<WeakReference<Consumer<T>>>(this.weakDataListeners);
            }
        }
        return Collections.emptyList();
    }

    private Set<Runnable> initListeners() {
        if (this.listeners == null) {
            this.listeners = new LinkedHashSet<Runnable>(1);
        }
        return this.listeners;
    }

    private Set<Consumer<T>> initDataListeners() {
        if (this.dataListeners == null) {
            this.dataListeners = new LinkedHashSet<Consumer<T>>(1);
        }
        return this.dataListeners;
    }

    private List<WeakReference<Runnable>> initWeakListeners() {
        if (this.weakListeners == null) {
            this.weakListeners = new ArrayList<WeakReference<Runnable>>(1);
        }
        return this.weakListeners;
    }

    private List<WeakReference<Consumer<T>>> initWeakDataListeners() {
        if (this.weakDataListeners == null) {
            this.weakDataListeners = new ArrayList<WeakReference<Consumer<T>>>(1);
        }
        return this.weakDataListeners;
    }
}

