/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.value;

import is.codion.common.value.AbstractValue;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

final class DefaultValueSet<T>
extends AbstractValue<Set<T>>
implements ValueSet<T> {
    private final Set<T> values = new LinkedHashSet<T>();
    private final Value<T> value = new SingleValue();

    DefaultValueSet(Set<T> initialValues, Value.Notify notify) {
        super(Collections.emptySet(), notify);
        this.set(Objects.requireNonNull(initialValues, "initialValues"));
    }

    @Override
    public void set(Collection<T> values) {
        this.set(values == null ? null : new LinkedHashSet<T>(values));
    }

    @Override
    public Set<T> get() {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(this.values));
    }

    @Override
    public boolean add(T value) {
        LinkedHashSet<T> newValues = new LinkedHashSet<T>(this.values);
        boolean added = newValues.add(value);
        this.set(newValues);
        return added;
    }

    @Override
    public boolean addAll(T ... values) {
        Objects.requireNonNull(values);
        LinkedHashSet<T> newValues = new LinkedHashSet<T>(this.values);
        boolean added = false;
        for (T val : values) {
            added = newValues.add(val) || added;
        }
        this.set(newValues);
        return added;
    }

    @Override
    public boolean remove(T value) {
        LinkedHashSet<T> newValues = new LinkedHashSet<T>(this.values);
        boolean removed = newValues.remove(value);
        this.set(newValues);
        return removed;
    }

    @Override
    public boolean removeAll(T ... values) {
        Objects.requireNonNull(values);
        LinkedHashSet<T> newValues = new LinkedHashSet<T>(this.values);
        boolean removed = false;
        for (T val : values) {
            removed = newValues.remove(val) || removed;
        }
        this.set(newValues);
        return removed;
    }

    @Override
    public boolean empty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return !this.empty();
    }

    @Override
    public void clear() {
        this.set(Collections.emptySet());
    }

    @Override
    public Value<T> value() {
        return this.value;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    protected void setValue(Set<T> values) {
        this.values.clear();
        this.values.addAll(values);
    }

    private class SingleValue
    extends AbstractValue<T> {
        private SingleValue() {
            super(null);
            DefaultValueSet.this.addListener(this::notifyListeners);
        }

        @Override
        public T get() {
            Object set = DefaultValueSet.this.get();
            return set.isEmpty() ? null : (Object)set.iterator().next();
        }

        @Override
        protected void setValue(T value) {
            DefaultValueSet.this.set(value == null ? Collections.emptySet() : Collections.singleton(value));
        }
    }
}

