/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.value;

import is.codion.common.event.Event;
import is.codion.common.value.DefaultValueObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueLink;
import is.codion.common.value.ValueObserver;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractValue<T>
implements Value<T> {
    private final Event<T> changeEvent = Event.event();
    private final T nullValue;
    private final Value.Notify notify;
    private final Set<Value.Validator<T>> validators = new LinkedHashSet<Value.Validator<T>>(0);
    private final Map<Value<T>, ValueLink<T>> linkedValues = new LinkedHashMap<Value<T>, ValueLink<T>>(0);
    private final Consumer<T> originalValueListener = new OriginalValueListener();
    private ValueObserver<T> observer;

    protected AbstractValue() {
        this(null);
    }

    protected AbstractValue(T nullValue) {
        this.nullValue = nullValue;
        this.notify = null;
    }

    protected AbstractValue(T nullValue, Value.Notify notify) {
        this.nullValue = nullValue;
        this.notify = Objects.requireNonNull(notify);
    }

    @Override
    public final boolean set(T value) {
        T newValue = value == null ? this.nullValue : value;
        for (Value.Validator<T> validator : this.validators) {
            validator.validate(newValue);
        }
        Object previousValue = this.get();
        this.setValue(newValue);
        return this.notifyListeners(!Objects.equals(previousValue, newValue));
    }

    @Override
    public final boolean map(Function<T, T> mapper) {
        return this.set(Objects.requireNonNull(mapper).apply(this.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ValueObserver<T> observer() {
        Event<T> event = this.changeEvent;
        synchronized (event) {
            if (this.observer == null) {
                this.observer = new DefaultValueObserver(this);
            }
            return this.observer;
        }
    }

    @Override
    public final boolean nullable() {
        return this.nullValue == null;
    }

    @Override
    public final void accept(T data) {
        this.set(data);
    }

    @Override
    public final boolean addListener(Runnable listener) {
        return this.changeEvent.addListener(listener);
    }

    @Override
    public final boolean removeListener(Runnable listener) {
        return this.changeEvent.removeListener(listener);
    }

    @Override
    public final boolean addDataListener(Consumer<T> listener) {
        return this.changeEvent.addDataListener(listener);
    }

    @Override
    public final boolean removeDataListener(Consumer<T> listener) {
        return this.changeEvent.removeDataListener(listener);
    }

    @Override
    public final boolean addWeakListener(Runnable listener) {
        return this.changeEvent.addWeakListener(listener);
    }

    @Override
    public final boolean removeWeakListener(Runnable listener) {
        return this.changeEvent.removeWeakListener(listener);
    }

    @Override
    public final boolean addWeakDataListener(Consumer<T> listener) {
        return this.changeEvent.addWeakDataListener(listener);
    }

    @Override
    public final boolean removeWeakDataListener(Consumer<T> listener) {
        return this.changeEvent.removeWeakDataListener(listener);
    }

    @Override
    public final void link(Value<T> originalValue) {
        if (this.linkedValues.containsKey(Objects.requireNonNull(originalValue))) {
            throw new IllegalStateException("Values are already linked");
        }
        this.linkedValues.put(originalValue, new ValueLink<T>(this, originalValue));
    }

    @Override
    public final void unlink(Value<T> originalValue) {
        if (!this.linkedValues.containsKey(Objects.requireNonNull(originalValue))) {
            throw new IllegalStateException("Values are not linked");
        }
        this.linkedValues.remove(originalValue).unlink();
    }

    @Override
    public final void link(ValueObserver<T> originalValue) {
        this.set(Objects.requireNonNull(originalValue).get());
        originalValue.addDataListener(this.originalValueListener);
    }

    @Override
    public final void unlink(ValueObserver<T> originalValue) {
        Objects.requireNonNull(originalValue).removeDataListener(this.originalValueListener);
    }

    @Override
    public final boolean addValidator(Value.Validator<T> validator) {
        Objects.requireNonNull(validator, "validator").validate(this.get());
        return this.validators.add(validator);
    }

    @Override
    public final boolean removeValidator(Value.Validator<T> validator) {
        return this.validators.remove(Objects.requireNonNull(validator));
    }

    @Override
    public final void validate(T value) {
        this.validators.forEach(validator -> validator.validate(value));
    }

    protected abstract void setValue(T var1);

    protected final void notifyListeners() {
        this.changeEvent.accept(this.get());
    }

    final Set<Value<T>> linkedValues() {
        return this.linkedValues.keySet();
    }

    final Collection<Value.Validator<T>> validators() {
        return this.validators;
    }

    private boolean notifyListeners(boolean changed) {
        if (this.notify == Value.Notify.WHEN_SET || this.notify == Value.Notify.WHEN_CHANGED && changed) {
            this.notifyListeners();
        }
        return changed;
    }

    private final class OriginalValueListener
    implements Consumer<T> {
        private OriginalValueListener() {
        }

        @Override
        public void accept(T value) {
            AbstractValue.this.set(value);
        }
    }
}

