/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.item;

import is.codion.common.Text;
import is.codion.common.item.Item;
import java.util.Comparator;
import java.util.Objects;

abstract class AbstractItem<T>
implements Item<T> {
    private static final long serialVersionUID = 1L;
    private final T value;
    private transient Comparator<String> collator;

    AbstractItem(T value) {
        this.value = value;
    }

    @Override
    public final T get() {
        return this.value;
    }

    @Override
    public final int compareTo(Item<T> item) {
        return this.collator().compare(this.caption(), item.caption());
    }

    public final String toString() {
        return this.caption();
    }

    public final boolean equals(Object obj) {
        return this == obj || obj instanceof Item && Objects.equals(this.value, ((Item)obj).get());
    }

    public final int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    private Comparator<String> collator() {
        if (this.collator == null) {
            this.collator = Text.spaceAwareCollator();
        }
        return this.collator;
    }
}

