/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common;

import is.codion.common.Separators;
import is.codion.common.property.PropertyStore;
import is.codion.common.property.PropertyValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class Configuration {
    public static final String CONFIGURATION_FILE = "codion.configurationFile";
    public static final String CONFIGURATION_FILE_REQUIRED = "codion.configurationFileRequired";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final PropertyStore STORE = Configuration.loadConfiguration();

    private Configuration() {
    }

    public static PropertyValue<Boolean> booleanValue(String key) {
        return STORE.booleanValue(key);
    }

    public static PropertyValue<Boolean> booleanValue(String key, boolean defaultValue) {
        return STORE.booleanValue(key, defaultValue);
    }

    public static PropertyValue<Integer> integerValue(String key) {
        return STORE.integerValue(key);
    }

    public static PropertyValue<Integer> integerValue(String key, int defaultValue) {
        return STORE.integerValue(key, defaultValue);
    }

    public static PropertyValue<Long> longValue(String key) {
        return STORE.longValue(key);
    }

    public static PropertyValue<Long> longValue(String key, long defaultValue) {
        return STORE.longValue(key, defaultValue);
    }

    public static PropertyValue<Double> doubleValue(String key) {
        return STORE.doubleValue(key);
    }

    public static PropertyValue<Double> doubleValue(String key, double defaultValue) {
        return STORE.doubleValue(key, defaultValue);
    }

    public static PropertyValue<Character> characterValue(String key) {
        return STORE.characterValue(key);
    }

    public static PropertyValue<Character> characterValue(String key, char defaultValue) {
        return STORE.characterValue(key, defaultValue);
    }

    public static PropertyValue<String> stringValue(String key) {
        return Configuration.stringValue(key, null);
    }

    public static PropertyValue<String> stringValue(String key, String defaultValue) {
        return STORE.stringValue(key, defaultValue);
    }

    public static <T extends Enum<T>> PropertyValue<T> enumValue(String key, Class<T> enumClass) {
        return Configuration.enumValue(key, enumClass, null);
    }

    public static <T extends Enum<T>> PropertyValue<T> enumValue(String key, Class<T> enumClass, T defaultValue) {
        return STORE.enumValue(key, enumClass, defaultValue);
    }

    public static <T> PropertyValue<List<T>> listValue(String key, Function<String, T> parser) {
        return Configuration.listValue(key, parser, Collections.emptyList());
    }

    public static <T> PropertyValue<List<T>> listValue(String key, Function<String, T> parser, List<T> defaultValue) {
        return STORE.listValue(key, parser, Objects::toString, defaultValue);
    }

    public static <T> PropertyValue<T> value(String key, Function<String, T> parser) {
        return Configuration.value(key, parser, null);
    }

    public static <T> PropertyValue<T> value(String key, Function<String, T> parser, T defaultValue) {
        return STORE.value(key, parser, Objects::toString, defaultValue);
    }

    private static PropertyStore loadConfiguration() {
        boolean configurationFileRequired = System.getProperty(CONFIGURATION_FILE_REQUIRED, "false").equalsIgnoreCase(Boolean.TRUE.toString());
        String configurationFilePath = System.getProperty(CONFIGURATION_FILE, System.getProperty("user.home") + Separators.FILE_SEPARATOR + "codion.config");
        if (configurationFilePath.toLowerCase().startsWith(CLASSPATH_PREFIX)) {
            return Configuration.loadFromClasspath(configurationFilePath, configurationFileRequired);
        }
        return Configuration.loadFromFile(configurationFilePath, configurationFileRequired);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static PropertyStore loadFromClasspath(String filePath, boolean configurationRequired) {
        String filepath = Configuration.classpathFilepath(filePath);
        try (InputStream configurationFileStream = Configuration.class.getClassLoader().getResourceAsStream(filepath);){
            if (configurationFileStream == null) {
                if (configurationRequired) {
                    throw new RuntimeException("Required configuration file not found on classpath: " + filePath);
                }
                PropertyStore propertyStore2 = PropertyStore.propertyStore();
                return propertyStore2;
            }
            PropertyStore propertyStore = PropertyStore.propertyStore(configurationFileStream);
            return propertyStore;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load configuration from classpath: " + filePath, e);
        }
    }

    static PropertyStore loadFromFile(String filePath, boolean configurationRequired) {
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                if (configurationRequired) {
                    throw new RuntimeException("Required configuration file not found: " + filePath);
                }
                return PropertyStore.propertyStore();
            }
            return PropertyStore.propertyStore(file);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load configuration from file: " + filePath);
        }
    }

    private static String classpathFilepath(String filePath) {
        String path = filePath.substring(CLASSPATH_PREFIX.length());
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.contains("/")) {
            throw new IllegalArgumentException("Configuration files must be in the classpath root");
        }
        return path;
    }
}

