/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.property;

import is.codion.common.property.DefaultPropertyStore;
import is.codion.common.property.PropertyValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface PropertyStore {
    public PropertyValue<Boolean> booleanValue(String var1);

    public PropertyValue<Boolean> booleanValue(String var1, boolean var2);

    public PropertyValue<Double> doubleValue(String var1);

    public PropertyValue<Double> doubleValue(String var1, double var2);

    public PropertyValue<Integer> integerValue(String var1);

    public PropertyValue<Integer> integerValue(String var1, int var2);

    public PropertyValue<Long> longValue(String var1);

    public PropertyValue<Long> longValue(String var1, long var2);

    public PropertyValue<Character> characterValue(String var1);

    public PropertyValue<Character> characterValue(String var1, char var2);

    public PropertyValue<String> stringValue(String var1);

    public PropertyValue<String> stringValue(String var1, String var2);

    public <T extends Enum<T>> PropertyValue<T> enumValue(String var1, Class<T> var2);

    public <T extends Enum<T>> PropertyValue<T> enumValue(String var1, Class<T> var2, T var3);

    public <T> PropertyValue<List<T>> listValue(String var1, Function<String, T> var2, Function<T, String> var3);

    public <T> PropertyValue<List<T>> listValue(String var1, Function<String, T> var2, Function<T, String> var3, List<T> var4);

    public <T> PropertyValue<T> value(String var1, Function<String, T> var2, Function<T, String> var3);

    public <T> PropertyValue<T> value(String var1, Function<String, T> var2, Function<T, String> var3, T var4);

    public <T> Optional<PropertyValue<T>> propertyValue(String var1);

    public void setProperty(String var1, String var2);

    public String getProperty(String var1);

    public Collection<String> properties(String var1);

    public Collection<String> propertyNames(String var1);

    public boolean containsProperty(String var1);

    public void removeAll(String var1);

    public void writeToFile(File var1) throws IOException;

    public static PropertyStore propertyStore() {
        return PropertyStore.propertyStore(new Properties());
    }

    public static PropertyStore propertyStore(InputStream inputStream) throws IOException {
        return new DefaultPropertyStore(inputStream);
    }

    public static PropertyStore propertyStore(File propertiesFile) throws IOException {
        return new DefaultPropertyStore(propertiesFile);
    }

    public static PropertyStore propertyStore(Properties properties) {
        return new DefaultPropertyStore(properties);
    }

    public static String systemProperties() {
        return PropertyStore.systemProperties((property, value) -> value);
    }

    public static String systemProperties(PropertyFormatter propertyFormatter) {
        Objects.requireNonNull(propertyFormatter);
        Properties properties = System.getProperties();
        return Collections.list(properties.propertyNames()).stream().filter(String.class::isInstance).map(String.class::cast).sorted().map(property -> property + ": " + propertyFormatter.formatValue((String)property, properties.getProperty((String)property))).collect(Collectors.joining("\n"));
    }

    public static interface PropertyFormatter {
        public String formatValue(String var1, String var2);
    }
}

