/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class Primitives {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_BOXED_TYPE_MAP = new HashMap();
    private static final Map<Class<?>, Object> DEFAULT_PRIMITIVE_VALUES;
    private static boolean defaultBoolean;
    private static byte defaultByte;
    private static short defaultShort;
    private static int defaultInt;
    private static long defaultLong;
    private static float defaultFloat;
    private static double defaultDouble;

    private Primitives() {
    }

    public static <T> T defaultValue(Class<T> primitiveType) {
        if (!Objects.requireNonNull(primitiveType).isPrimitive()) {
            throw new IllegalArgumentException("Not a primitive type: " + primitiveType);
        }
        return (T)DEFAULT_PRIMITIVE_VALUES.get(primitiveType);
    }

    public static <T> Class<T> boxedType(Class<T> primitiveType) {
        if (!Objects.requireNonNull(primitiveType).isPrimitive()) {
            throw new IllegalArgumentException("Not a primitive type: " + primitiveType);
        }
        return PRIMITIVE_BOXED_TYPE_MAP.get(primitiveType);
    }

    static {
        PRIMITIVE_BOXED_TYPE_MAP.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_BOXED_TYPE_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_BOXED_TYPE_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_BOXED_TYPE_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_BOXED_TYPE_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_BOXED_TYPE_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_BOXED_TYPE_MAP.put(Double.TYPE, Double.class);
        DEFAULT_PRIMITIVE_VALUES = new HashMap();
        DEFAULT_PRIMITIVE_VALUES.put(Boolean.TYPE, defaultBoolean);
        DEFAULT_PRIMITIVE_VALUES.put(Byte.TYPE, defaultByte);
        DEFAULT_PRIMITIVE_VALUES.put(Short.TYPE, defaultShort);
        DEFAULT_PRIMITIVE_VALUES.put(Integer.TYPE, defaultInt);
        DEFAULT_PRIMITIVE_VALUES.put(Long.TYPE, defaultLong);
        DEFAULT_PRIMITIVE_VALUES.put(Float.TYPE, Float.valueOf(defaultFloat));
        DEFAULT_PRIMITIVE_VALUES.put(Double.TYPE, defaultDouble);
    }
}

