/*
 * Decompiled with CFR 0.152.
 */
package ir.a2mo.sdk.sample.server.rest.exceptionhandler;

import ir.a2mo.sdk.autoconfigure.impl.feign.ErrorObject;
import ir.a2mo.sdk.sample.server.api.exception.CustomServerException;
import java.util.HashMap;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class RestExceptionHandler
extends ResponseEntityExceptionHandler {
    @ExceptionHandler(value={CustomServerException.class})
    @ResponseBody
    public ResponseEntity<ErrorObject> exception(CustomServerException customServerException) {
        ErrorObject errorObject = this.convertCustomServerExceptionToErrorObject(customServerException);
        return ResponseEntity.badRequest().body((Object)errorObject);
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseBody
    public ResponseEntity<ErrorObject> exception(Throwable throwable) {
        ErrorObject errorObject = this.convertThrowableToErrorObject(throwable);
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)errorObject);
    }

    private ErrorObject convertCustomServerExceptionToErrorObject(CustomServerException customServerException) {
        ErrorObject errorObject = new ErrorObject();
        errorObject.setErrorType(customServerException.getErrorType());
        errorObject.setErrorCode(customServerException.getErrorCode());
        errorObject.setMessage(customServerException.getMessage());
        errorObject.setErrorParam(customServerException.getErrorParam());
        return errorObject;
    }

    private ErrorObject convertThrowableToErrorObject(Throwable throwable) {
        ErrorObject errorObject = new ErrorObject();
        errorObject.setErrorType("throwable");
        errorObject.setErrorCode(throwable.getClass().getSimpleName());
        errorObject.setMessage(throwable.getMessage());
        HashMap<String, String> errorParam = new HashMap<String, String>();
        errorParam.put("localizedMessage", throwable.getLocalizedMessage());
        errorObject.setErrorParam(errorParam);
        return errorObject;
    }
}

