/*
 * Decompiled with CFR 0.152.
 */
package ir.a2mo.sdk.sample.server.api.config.feign;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.Logger;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.form.spring.SpringFormEncoder;
import feign.httpclient.ApacheHttpClient;
import feign.slf4j.Slf4jLogger;
import ir.a2mo.sdk.autoconfigure.HttpClientProperties;
import ir.a2mo.sdk.autoconfigure.impl.ConfigurableApacheHttpClientFactory;
import ir.a2mo.sdk.autoconfigure.impl.feign.CustomErrorDecoder;
import ir.a2mo.sdk.autoconfigure.impl.feign.CustomErrorDecoderConfig;
import ir.a2mo.sdk.autoconfigure.impl.feign.ExceptionExtractType;
import ir.a2mo.sdk.autoconfigure.impl.feign.exception.SdkWebServiceRuntimeException;
import ir.a2mo.sdk.sample.server.api.config.CustomServerClientConfigurationException;
import ir.a2mo.sdk.sample.server.api.config.properties.CustomServerClientConfig;
import ir.a2mo.sdk.sample.server.api.controller.CustomServerRestController;
import ir.a2mo.sdk.sample.server.api.exception.CustomServerException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientConnectionManagerFactory;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientFactory;
import org.springframework.cloud.commons.httpclient.DefaultApacheHttpClientConnectionManagerFactory;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.support.ResponseEntityDecoder;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration
@EnableFeignClients
public class CustomServerFeignConfig {
    private static final Logger log = LoggerFactory.getLogger(CustomServerFeignConfig.class);

    @Bean(value={"customServer-objectMapper"})
    public ObjectMapper customServerObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return objectMapper;
    }

    @Bean
    @ConfigurationProperties(prefix="custom-service")
    @ConditionalOnMissingBean
    public CustomServerClientConfig customServerClientConfig() {
        return new CustomServerClientConfig();
    }

    @Bean(value={"customServer-apacheHttpClientFactory"})
    public ApacheHttpClientFactory apacheHttpClientFactory(@Qualifier(value="customServer-httpClientBuilder") HttpClientBuilder builder, @Qualifier(value="customerServer-connectionManagerFactory") ApacheHttpClientConnectionManagerFactory clientConnectionManagerFactory, CustomServerClientConfig customServerClientConfig) {
        return new ConfigurableApacheHttpClientFactory(builder, clientConnectionManagerFactory, (HttpClientProperties)customServerClientConfig);
    }

    @Bean(value={"customServer-clientHttpRequestFactory"})
    public ClientHttpRequestFactory clientHttpRequestFactory(@Qualifier(value="customServer-apacheHttpClientFactory") ApacheHttpClientFactory apacheHttpClientFactory) {
        return new HttpComponentsClientHttpRequestFactory((HttpClient)apacheHttpClientFactory.createBuilder().build());
    }

    @Bean(value={"customServer-httpclient"})
    public CloseableHttpClient httpClient(@Qualifier(value="customServer-apacheHttpClientFactory") ApacheHttpClientFactory apacheHttpClientFactory) {
        return apacheHttpClientFactory.createBuilder().build();
    }

    @Bean(value={"customerServer-connectionManagerFactory"})
    public ApacheHttpClientConnectionManagerFactory connectionManagerFactory() {
        return new DefaultApacheHttpClientConnectionManagerFactory();
    }

    @Bean(value={"customServer-feignClient"})
    public Client feignClient(@Qualifier(value="customServer-httpclient") HttpClient httpClient) {
        return new ApacheHttpClient(httpClient);
    }

    @Bean(value={"customServer-requestInterceptor"})
    public RequestInterceptor requestInterceptor() {
        return requestTemplate -> {
            requestTemplate.header("Accept", new String[]{ContentType.APPLICATION_JSON.getMimeType()});
            requestTemplate.header("Content-Type", new String[]{ContentType.APPLICATION_JSON.getMimeType()});
        };
    }

    @Bean(value={"customServer-requestInterceptors"})
    public List<RequestInterceptor> requestInterceptors(CustomServerClientConfig customServerClientConfig, @Qualifier(value="customServer-requestInterceptor") RequestInterceptor requestInterceptor) {
        ArrayList<RequestInterceptor> requestInterceptors = new ArrayList<RequestInterceptor>();
        requestInterceptors.add(requestInterceptor);
        HttpClientProperties.AuthorizationConfiguration authorizationConfiguration = customServerClientConfig.getAuthorizationConfiguration();
        if (customServerClientConfig.getAuthorizationConfiguration().isEnable()) {
            requestInterceptors.add((RequestInterceptor)new BasicAuthRequestInterceptor(authorizationConfiguration.getUsername(), authorizationConfiguration.getPassword(), StandardCharsets.UTF_8));
        }
        return requestInterceptors;
    }

    @Bean(value={"customServer-feignContract"})
    public Contract feignContract() {
        return new SpringMvcContract();
    }

    @Bean(value={"customServer-feignEncoder"})
    public Encoder feignEncoder(@Qualifier(value="customServer-objectMapper") ObjectMapper objectMapper) {
        return new SpringFormEncoder((Encoder)new SpringEncoder(this.getHttpMessageConverter(objectMapper)));
    }

    @Bean(value={"customServer-feignDecoder"})
    public Decoder feignDecoder(@Qualifier(value="customServer-objectMapper") ObjectMapper objectMapper) {
        return new ResponseEntityDecoder((Decoder)new SpringDecoder(this.getHttpMessageConverter(objectMapper)));
    }

    private ObjectFactory<HttpMessageConverters> getHttpMessageConverter(ObjectMapper objectMapper) {
        MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = new MappingJackson2HttpMessageConverter(objectMapper);
        return () -> new HttpMessageConverters(new HttpMessageConverter[]{mappingJackson2HttpMessageConverter});
    }

    @Bean(value={"customServer-feignErrorDecoderConfig"})
    public CustomErrorDecoderConfig customErrorDecoderConfig(@Qualifier(value="customServer-objectMapper") ObjectMapper objectMapper) {
        CustomErrorDecoderConfig customErrorDecoderConfig = new CustomErrorDecoderConfig();
        customErrorDecoderConfig.getScanPackageList().add("ir.a2mo.sdk.sample.server.api.exception");
        customErrorDecoderConfig.setExceptionExtractType(ExceptionExtractType.EXCEPTION_IDENTIFIER_FIELDS);
        customErrorDecoderConfig.setCheckedExceptionClass(CustomServerException.class);
        customErrorDecoderConfig.setUncheckedExceptionClass(SdkWebServiceRuntimeException.class);
        customErrorDecoderConfig.setObjectMapper(objectMapper);
        return customErrorDecoderConfig;
    }

    @Bean(value={"customServer-feignErrorDecoder"})
    public CustomErrorDecoder customErrorDecoder(@Qualifier(value="customServer-feignErrorDecoderConfig") CustomErrorDecoderConfig customErrorDecoderConfig) {
        return new CustomErrorDecoder(customErrorDecoderConfig);
    }

    @Bean(value={"customServer-httpClientBuilder"})
    public HttpClientBuilder apacheHttpClientBuilder() {
        return HttpClientBuilder.create();
    }

    @Bean(value={"customServer-retryer"})
    @ConditionalOnMissingBean(name={"customServer-retryer"})
    public Retryer retryer() {
        return Retryer.NEVER_RETRY;
    }

    @Bean(value={"customServer-feignLoggerLevel"})
    @ConditionalOnMissingBean(name={"customServer-feignLoggerLevel"})
    public Logger.Level feignLoggerLevel() {
        return Logger.Level.FULL;
    }

    @Bean(value={"customServer-feignOption"})
    Request.Options options(CustomServerClientConfig customServerClientConfig) {
        HttpClientProperties.ConnectionConfiguration connectionConfiguration = customServerClientConfig.getConnectionConfiguration();
        return new Request.Options((long)connectionConfiguration.getConnectionTimeout(), TimeUnit.MILLISECONDS, (long)connectionConfiguration.getSocketTimeout(), TimeUnit.MILLISECONDS, connectionConfiguration.isFollowRedirects());
    }

    @Bean
    public CustomServerRestController clientServerRestController(CustomServerClientConfig customServerClientConfig, @Qualifier(value="customServer-feignClient") Client feignClient, @Qualifier(value="customServer-feignOption") Request.Options options, @Qualifier(value="customServer-requestInterceptors") List<RequestInterceptor> requestInterceptors, @Qualifier(value="customServer-feignContract") Contract feignContract, @Qualifier(value="customServer-feignDecoder") Decoder springDecoder, @Qualifier(value="customServer-feignEncoder") Encoder feignFormEncoder, @Qualifier(value="customServer-retryer") Retryer retryer, @Qualifier(value="customServer-feignLoggerLevel") Logger.Level logLevel, @Qualifier(value="customServer-feignErrorDecoder") CustomErrorDecoder customErrorDecoder) {
        if (customServerClientConfig.getBaseServiceUrl() == null) {
            log.error("baseServiceUrl of customServer web service must be set and not be null or empty.");
            throw new CustomServerClientConfigurationException("baseServiceUrl of customServer web service must be set and not be null or empty.");
        }
        return (CustomServerRestController)Feign.builder().client(feignClient).options(options).encoder(feignFormEncoder).decoder(springDecoder).errorDecoder((ErrorDecoder)customErrorDecoder).contract(feignContract).requestInterceptors(requestInterceptors).retryer(retryer).logger((feign.Logger)new Slf4jLogger(CustomServerRestController.class)).logLevel(logLevel).target(CustomServerRestController.class, customServerClientConfig.getBaseServiceUrl());
    }
}

