/*
 * Decompiled with CFR 0.152.
 */
package ir.a2mo.sdk.autoconfigure.impl.feign;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import feign.Response;
import feign.codec.ErrorDecoder;
import ir.a2mo.sdk.autoconfigure.impl.feign.CustomErrorDecoderConfig;
import ir.a2mo.sdk.autoconfigure.impl.feign.ErrorObject;
import ir.a2mo.sdk.autoconfigure.impl.feign.ExceptionExtractType;
import ir.a2mo.sdk.autoconfigure.impl.feign.exception.FeignConfigurationException;
import ir.a2mo.sdk.autoconfigure.impl.feign.exception.InternalServerException;
import ir.a2mo.sdk.autoconfigure.impl.feign.exception.JsonConvertException;
import ir.a2mo.sdk.autoconfigure.impl.feign.exception.SdkWebServiceBaseException;
import ir.a2mo.sdk.autoconfigure.impl.feign.exception.SdkWebServiceException;
import ir.a2mo.sdk.autoconfigure.impl.feign.exception.SdkWebServiceRuntimeException;
import ir.a2mo.sdk.autoconfigure.impl.feign.exception.UnknownException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StreamUtils;

public class CustomErrorDecoder
implements ErrorDecoder,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomErrorDecoder.class);
    private final CustomErrorDecoderConfig customErrorDecoderConfig;
    private ObjectMapper objectMapper;

    public CustomErrorDecoder(CustomErrorDecoderConfig customErrorDecoderConfig) {
        this.customErrorDecoderConfig = customErrorDecoderConfig;
    }

    public Exception decode(String methodKey, Response response) {
        try {
            Response.Body body = response.body();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            StreamUtils.copy((InputStream)body.asInputStream(), (OutputStream)output);
            String responseBody = new String(output.toByteArray());
            int status = response.status();
            Map<String, Class<? extends Exception>> exceptionMap = this.customErrorDecoderConfig.getExceptionMap();
            if (status >= 400 && status < 500) {
                LOGGER.debug("serverResponseException :\n responseStatus:{}\n responseBody:{}", (Object)status, (Object)responseBody);
                ErrorObject errorObject = this.jsonToObject(responseBody, ErrorObject.class);
                String errorType = errorObject.getErrorType();
                String errorCode = errorObject.getErrorCode();
                String errorKey = errorType + "." + errorCode;
                Class<? extends Exception> exceptionClass = exceptionMap.get(errorKey);
                if (exceptionClass != null) {
                    return this.jsonToObject(responseBody, exceptionClass);
                }
                UnknownException unknownException = this.jsonToObject(responseBody, UnknownException.class);
                unknownException.setJsonResponse(responseBody);
                return unknownException;
            }
            LOGGER.debug("ServerInternalRuntimeException :\n responseStatus:{}\n responseBody:{}", (Object)response.status(), (Object)responseBody);
            InternalServerException internalServerException = this.jsonToObject(responseBody, InternalServerException.class);
            if (internalServerException.getErrorParam() == null) {
                HashMap<String, Object> errorMap = new HashMap<String, Object>();
                internalServerException.setErrorParam(errorMap);
            }
            String errorType = internalServerException.getErrorType();
            String errorCode = internalServerException.getErrorCode();
            String errorKey = errorType + "." + errorCode;
            Class<? extends Exception> cause = exceptionMap.get(errorKey);
            internalServerException.getErrorParam().put("httpStatusCode", status);
            internalServerException.getErrorParam().put("cause", cause);
            internalServerException.setJsonResponse(responseBody);
            return internalServerException;
        }
        catch (Exception e) {
            LOGGER.warn("ServerInternalRuntimeException", (Throwable)e);
            InternalServerException internalServerException = new InternalServerException("Internal error", e);
            internalServerException.setErrorType("customErrorDecoder");
            internalServerException.setErrorCode(e.getClass().getSimpleName());
            HashMap<String, Object> exceptionErrorMap = new HashMap<String, Object>();
            exceptionErrorMap.put("localizedMessage", e.getLocalizedMessage());
            internalServerException.setErrorParam(exceptionErrorMap);
            internalServerException.setMessage(e.getMessage());
            return internalServerException;
        }
    }

    private <T> T jsonToObject(String string, Class<T> type) {
        try {
            return (T)this.objectMapper.readValue(string, type);
        }
        catch (Exception e) {
            throw new JsonConvertException("error in converting Json to object");
        }
    }

    public void afterPropertiesSet() {
        ExceptionExtractType exceptionExtractType;
        if (this.customErrorDecoderConfig != null) {
            this.objectMapper = this.customErrorDecoderConfig.getObjectMapper() != null ? this.customErrorDecoderConfig.getObjectMapper() : this.getDefaultObjectMapper();
            exceptionExtractType = this.customErrorDecoderConfig.getExceptionExtractType();
        } else {
            this.objectMapper = this.getDefaultObjectMapper();
            exceptionExtractType = ExceptionExtractType.STATIC_MAP;
        }
        if (exceptionExtractType != null && (exceptionExtractType.equals((Object)ExceptionExtractType.EXCEPTION_IDENTIFIER_FIELDS) || exceptionExtractType.equals((Object)ExceptionExtractType.FULL_NAME_REFLECTION))) {
            List<String> scanPackageList = this.customErrorDecoderConfig.getScanPackageList();
            Class<? extends SdkWebServiceException> checkedExceptionClass = this.customErrorDecoderConfig.getCheckedExceptionClass();
            Class<? extends SdkWebServiceRuntimeException> uncheckedExceptionClass = this.customErrorDecoderConfig.getUncheckedExceptionClass();
            if (CollectionUtils.isEmpty(scanPackageList) || checkedExceptionClass == null || uncheckedExceptionClass == null) {
                throw new FeignConfigurationException("packageList and checkedExceptionClass and uncheckedExceptionClass be filled when extractType is EXCEPTION_IDENTIFIER_FIELDS or FULL_NAME_REFLECTION");
            }
            Reflections reflections = new Reflections(scanPackageList.toArray());
            reflections.getSubTypesOf(checkedExceptionClass).forEach(this::extractAndFillMap);
            reflections.getSubTypesOf(uncheckedExceptionClass).forEach(this::extractAndFillMap);
        }
    }

    private ObjectMapper getDefaultObjectMapper() {
        ObjectMapper defaultObjectMapper = new ObjectMapper();
        defaultObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        defaultObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        defaultObjectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        return defaultObjectMapper;
    }

    private void extractAndFillMap(Class<? extends Exception> type) {
        ExceptionExtractType exceptionExtractType = this.customErrorDecoderConfig.getExceptionExtractType();
        Map<String, Class<? extends Exception>> exceptionMap = this.customErrorDecoderConfig.getExceptionMap();
        if (exceptionExtractType.equals((Object)ExceptionExtractType.EXCEPTION_IDENTIFIER_FIELDS)) {
            try {
                SdkWebServiceBaseException exception = (SdkWebServiceBaseException)((Object)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                String exceptionKey = exception.getErrorType() + "." + exception.getErrorCode();
                exceptionMap.put(exceptionKey, type);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.warn("error on construction of {}.", (Object)type.getSimpleName());
                LOGGER.warn("Exception:", (Throwable)e);
            }
        } else if (exceptionExtractType.equals((Object)ExceptionExtractType.FULL_NAME_REFLECTION)) {
            exceptionMap.put(type.getName(), type);
        }
    }
}

