/*
 * Decompiled with CFR 0.152.
 */
package ir.a2mo.sdk.autoconfigure.impl.certificates;

import ir.a2mo.sdk.autoconfigure.HttpClientProperties;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class CertificateLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateLoader.class);

    private CertificateLoader() {
    }

    public static SSLContext buildSSLContext(HttpClientProperties.SSLConfiguration sslConfiguration, KeyManagerFactory keyManagerFactory, TrustManagerFactory trustManagerFactory) {
        try {
            SSLContext sslContext = SSLContext.getInstance(sslConfiguration.getContext());
            sslContext.init(keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null, trustManagerFactory != null ? trustManagerFactory.getTrustManagers() : null, null);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            LOGGER.error("Could not build SSLContext, skipping", (Throwable)ex);
            return null;
        }
    }

    public static SSLContext buildSSLContext(HttpClientProperties.SSLConfiguration sslConfiguration, KeyStore keyStore, KeyStore trustStore) {
        try {
            TrustStrategy trustStrategy = null;
            if (!sslConfiguration.isCheckValidity()) {
                trustStrategy = (chain, authType) -> true;
            }
            return SSLContexts.custom().loadKeyMaterial(keyStore, sslConfiguration.getKeystore().getPassword().toCharArray()).loadTrustMaterial(trustStore, trustStrategy).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            LOGGER.error("Could not build SSLContext, skipping", (Throwable)ex);
            return null;
        }
    }

    public static TrustManagerFactory getTrustManagerFactory(HttpClientProperties.SSLConfiguration sslConfiguration) {
        TrustManagerFactory trustManagerFactory;
        HttpClientProperties.TruststoreConfiguration truststoreConfiguration = sslConfiguration.getTruststore();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{truststoreConfiguration.getPath(), truststoreConfiguration.getPassword()})) {
            LOGGER.warn("Truststore Configuration incomplete, skipping");
            return null;
        }
        FileInputStream is = new FileInputStream(ResourceUtils.getFile((String)truststoreConfiguration.getPath()));
        try {
            KeyStore keyStore = KeyStore.getInstance(truststoreConfiguration.getType());
            keyStore.load(is, truststoreConfiguration.getPassword().toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            LOGGER.info("Truststore initialized successfully");
            trustManagerFactory = tmf;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                LOGGER.error("Truststore could not be loaded, skipping", (Throwable)ex);
                return null;
            }
        }
        is.close();
        return trustManagerFactory;
    }

    public static KeyManagerFactory getKeyManagerFactory(HttpClientProperties.SSLConfiguration sslConfiguration) {
        KeyManagerFactory keyManagerFactory;
        HttpClientProperties.KeystoreConfiguration keystoreConfiguration = sslConfiguration.getKeystore();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{keystoreConfiguration.getPath(), keystoreConfiguration.getPassword()})) {
            LOGGER.warn("Keystore Configuration incomplete, skipping");
            return null;
        }
        FileInputStream is = new FileInputStream(ResourceUtils.getFile((String)keystoreConfiguration.getPath()));
        try {
            KeyStore keyStore = KeyStore.getInstance(keystoreConfiguration.getType());
            keyStore.load(is, keystoreConfiguration.getPassword().toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, keystoreConfiguration.getPassword().toCharArray());
            LOGGER.info("Keystore initialized successfully");
            keyManagerFactory = kmf;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
                LOGGER.error("Keystore could not be loaded, skipping", (Throwable)ex);
                return null;
            }
        }
        is.close();
        return keyManagerFactory;
    }

    public static KeyStore getKeyStore(HttpClientProperties.SSLConfiguration sslConfiguration) {
        HttpClientProperties.KeystoreConfiguration keystoreConfiguration = sslConfiguration.getKeystore();
        return CertificateLoader.getStore(keystoreConfiguration.getPath(), keystoreConfiguration.getPassword(), keystoreConfiguration.getType());
    }

    public static KeyStore getTrustStore(HttpClientProperties.SSLConfiguration sslConfiguration) {
        HttpClientProperties.TruststoreConfiguration truststoreConfiguration = sslConfiguration.getTruststore();
        return CertificateLoader.getStore(truststoreConfiguration.getPath(), truststoreConfiguration.getPassword(), truststoreConfiguration.getType());
    }

    private static KeyStore getStore(String path, String password, String type) {
        KeyStore keyStore;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{path, password})) {
            LOGGER.warn("Keystore Configuration incomplete, skipping");
            return null;
        }
        FileInputStream is = new FileInputStream(ResourceUtils.getFile((String)path));
        try {
            KeyStore keyStore2 = KeyStore.getInstance(type);
            keyStore2.load(is, password.toCharArray());
            LOGGER.info("Keystore initialized successfully");
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                LOGGER.error("Keystore could not be loaded, skipping", (Throwable)ex);
                return null;
            }
        }
        is.close();
        return keyStore;
    }
}

