/*
 * Decompiled with CFR 0.152.
 */
package ir.a2mo.sdk.autoconfigure.impl;

import ir.a2mo.sdk.autoconfigure.HttpClientProperties;
import ir.a2mo.sdk.autoconfigure.impl.certificates.CertificateLoader;
import java.security.KeyStore;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientConnectionManagerFactory;
import org.springframework.cloud.commons.httpclient.DefaultApacheHttpClientFactory;

public class ConfigurableApacheHttpClientFactory
extends DefaultApacheHttpClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurableApacheHttpClientFactory.class);
    private final HttpClientProperties httpClientProperties;
    private final ApacheHttpClientConnectionManagerFactory clientConnectionManagerFactory;
    private final Timer connectionManagerTimer = new Timer("FeignApacheHttpClientConfiguration.connectionManagerTimer", true);

    public ConfigurableApacheHttpClientFactory(HttpClientBuilder builder, ApacheHttpClientConnectionManagerFactory connectionManagerFactory, HttpClientProperties httpClientProperties) {
        super(builder);
        this.httpClientProperties = httpClientProperties;
        this.clientConnectionManagerFactory = connectionManagerFactory;
    }

    public HttpClientBuilder createBuilder() {
        HttpClientProperties.ProxyConfiguration proxyConfig;
        HttpClientBuilder builder = super.createBuilder();
        this.configureTimeouts(builder);
        this.configureConnectionManager(builder);
        String baseServiceUrl = this.httpClientProperties.getBaseServiceUrl();
        if (baseServiceUrl != null && baseServiceUrl.startsWith("https")) {
            this.configureSSL(builder);
        }
        if ((proxyConfig = this.httpClientProperties.getProxy()).isEnable()) {
            this.configureProxy(builder, proxyConfig);
            this.configureAuthentication(builder, proxyConfig);
        }
        return builder;
    }

    private void configureTimeouts(HttpClientBuilder builder) {
        builder.setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(this.httpClientProperties.getConnectionConfiguration().getConnectionTimeout()).setSocketTimeout(this.httpClientProperties.getConnectionConfiguration().getSocketTimeout()).build());
    }

    private void configureConnectionManager(HttpClientBuilder builder) {
        final HttpClientConnectionManager connectionManager = this.clientConnectionManagerFactory.newConnectionManager(this.httpClientProperties.getSsl().isCheckValidity(), this.httpClientProperties.getConnectionConfiguration().getMaxConnections(), this.httpClientProperties.getConnectionConfiguration().getMaxConnectionsPerRoute(), this.httpClientProperties.getConnectionConfiguration().getTimeToLive(), this.httpClientProperties.getConnectionConfiguration().getTimeToLiveUnit(), null);
        this.connectionManagerTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                connectionManager.closeExpiredConnections();
            }
        }, 30000L, (long)this.httpClientProperties.getConnectionConfiguration().getConnectionTimerRepeat());
        builder.setConnectionManager(connectionManager);
    }

    private void configureSSL(HttpClientBuilder builder) {
        DefaultHostnameVerifier hostnameVerifier;
        HttpClientProperties.SSLConfiguration sslConfiguration = this.httpClientProperties.getSsl();
        KeyStore trustStore = CertificateLoader.getTrustStore(sslConfiguration);
        KeyStore keyStore = CertificateLoader.getKeyStore(sslConfiguration);
        SSLContext sslContext = CertificateLoader.buildSSLContext(sslConfiguration, keyStore, trustStore);
        if (sslConfiguration.isCheckValidity()) {
            hostnameVerifier = new DefaultHostnameVerifier();
        } else {
            LOGGER.warn("SSL validity check is disabled for url '{}'", (Object)this.httpClientProperties.getBaseServiceUrl());
            hostnameVerifier = NoopHostnameVerifier.INSTANCE;
        }
        if (sslContext != null) {
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
        } else {
            LOGGER.warn("Invalid SSL Context, skipping");
        }
    }

    private void configureProxy(HttpClientBuilder builder, HttpClientProperties.ProxyConfiguration proxyConfig) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{proxyConfig.getHost(), proxyConfig.getPort()})) {
            builder.setProxy(new HttpHost(proxyConfig.getHost(), Integer.parseInt(proxyConfig.getPort())));
        } else {
            LOGGER.warn("Invalid Proxy Host, skipping");
        }
    }

    private void configureAuthentication(HttpClientBuilder builder, HttpClientProperties.ProxyConfiguration proxyConfig) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        boolean hasCredentials = false;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{proxyConfig.getUser(), proxyConfig.getPassword()})) {
            credentialsProvider.setCredentials(new AuthScope(proxyConfig.getHost(), Integer.parseInt(proxyConfig.getPort())), (Credentials)new UsernamePasswordCredentials(proxyConfig.getUser(), proxyConfig.getPassword()));
            hasCredentials = true;
        }
        if (hasCredentials) {
            builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            builder.setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
        }
    }
}

