/*
 * Decompiled with CFR 0.152.
 */
package ir.a2mo.sdk.autoconfigure;

import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.validation.annotation.Validated;

@Validated
public class HttpClientProperties {
    private String baseServiceUrl;
    @NestedConfigurationProperty
    private SSLConfiguration ssl = new SSLConfiguration();
    @NestedConfigurationProperty
    private ProxyConfiguration proxy = new ProxyConfiguration();
    @NestedConfigurationProperty
    private ConnectionConfiguration connectionConfiguration = new ConnectionConfiguration();
    @NestedConfigurationProperty
    private AuthorizationConfiguration authorizationConfiguration = new AuthorizationConfiguration();

    public String getBaseServiceUrl() {
        return this.baseServiceUrl;
    }

    public void setBaseServiceUrl(String baseServiceUrl) {
        this.baseServiceUrl = baseServiceUrl;
    }

    public SSLConfiguration getSsl() {
        return this.ssl;
    }

    public void setSsl(SSLConfiguration ssl) {
        this.ssl = ssl;
    }

    public ProxyConfiguration getProxy() {
        return this.proxy;
    }

    public void setProxy(ProxyConfiguration proxy) {
        this.proxy = proxy;
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    public void setConnectionConfiguration(ConnectionConfiguration connectionConfiguration) {
        this.connectionConfiguration = connectionConfiguration;
    }

    public AuthorizationConfiguration getAuthorizationConfiguration() {
        return this.authorizationConfiguration;
    }

    public void setAuthorizationConfiguration(AuthorizationConfiguration authorizationConfiguration) {
        this.authorizationConfiguration = authorizationConfiguration;
    }

    public static class AuthorizationConfiguration {
        private boolean enable;
        private String username;
        private String password;

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    @Validated
    public static class ConnectionConfiguration {
        public static final int DEFAULT_MAX_CONNECTIONS = 200;
        public static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 50;
        public static final long DEFAULT_TIME_TO_LIVE = 900L;
        public static final TimeUnit DEFAULT_TIME_TO_LIVE_UNIT = TimeUnit.SECONDS;
        public static final boolean DEFAULT_FOLLOW_REDIRECTS = true;
        public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
        public static final int DEFAULT_CONNECTION_TIMER_REPEAT = 3000;
        public static final int DEFAULT_SOCKET_TIMEOUT = 10000;
        private int maxConnections = 200;
        private int maxConnectionsPerRoute = 50;
        private long timeToLive = 900L;
        private TimeUnit timeToLiveUnit = DEFAULT_TIME_TO_LIVE_UNIT;
        private boolean followRedirects = true;
        private int connectionTimeout = 5000;
        private int connectionTimerRepeat = 3000;
        private int socketTimeout = 10000;

        public int getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
        }

        public int getMaxConnectionsPerRoute() {
            return this.maxConnectionsPerRoute;
        }

        public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
            this.maxConnectionsPerRoute = maxConnectionsPerRoute;
        }

        public long getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLive(long timeToLive) {
            this.timeToLive = timeToLive;
        }

        public TimeUnit getTimeToLiveUnit() {
            return this.timeToLiveUnit;
        }

        public void setTimeToLiveUnit(TimeUnit timeToLiveUnit) {
            this.timeToLiveUnit = timeToLiveUnit;
        }

        public boolean isFollowRedirects() {
            return this.followRedirects;
        }

        public void setFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
        }

        public int getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public void setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public int getConnectionTimerRepeat() {
            return this.connectionTimerRepeat;
        }

        public void setConnectionTimerRepeat(int connectionTimerRepeat) {
            this.connectionTimerRepeat = connectionTimerRepeat;
        }

        public int getSocketTimeout() {
            return this.socketTimeout;
        }

        public void setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
        }
    }

    public static class TruststoreConfiguration {
        private String path;
        private String password;
        private String type = "JKS";

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class KeystoreConfiguration {
        private String path;
        private String password;
        private String type = "JKS";

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class SSLConfiguration {
        private String context = "TLSv1.2";
        private boolean checkValidity;
        @NestedConfigurationProperty
        private KeystoreConfiguration keystore = new KeystoreConfiguration();
        @NestedConfigurationProperty
        private TruststoreConfiguration truststore = new TruststoreConfiguration();

        public String getContext() {
            return this.context;
        }

        public void setContext(String context) {
            this.context = context;
        }

        public boolean isCheckValidity() {
            return this.checkValidity;
        }

        public void setCheckValidity(boolean checkValidity) {
            this.checkValidity = checkValidity;
        }

        public KeystoreConfiguration getKeystore() {
            return this.keystore;
        }

        public void setKeystore(KeystoreConfiguration keystore) {
            this.keystore = keystore;
        }

        public TruststoreConfiguration getTruststore() {
            return this.truststore;
        }

        public void setTruststore(TruststoreConfiguration truststore) {
            this.truststore = truststore;
        }
    }

    public static class ProxyConfiguration {
        private boolean enable;
        private String host;
        private String port;
        private String user;
        private String password;

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getPort() {
            return this.port;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

