/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.ui;

import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLJPanel;
import graphics.glimpse.GlimpseAdapter;
import graphics.glimpse.GlimpseCallback;
import graphics.glimpse.ui.GLCapabilitiesFactory;
import graphics.glimpse.ui.GlimpseComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\fB\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgraphics/glimpse/ui/GlimpsePanel;", "Lcom/jogamp/opengl/awt/GLJPanel;", "Lgraphics/glimpse/ui/GlimpseComponent;", "fixedScale", "", "(Z)V", "eventListener", "Lgraphics/glimpse/ui/GlimpsePanel$GlimpseEventListener;", "setCallback", "", "callback", "Lgraphics/glimpse/GlimpseCallback;", "GlimpseEventListener", "ui"})
public final class GlimpsePanel
extends GLJPanel
implements GlimpseComponent {
    private GlimpseEventListener eventListener;

    public GlimpsePanel(boolean fixedScale) {
        super((GLCapabilitiesImmutable)GLCapabilitiesFactory.INSTANCE.create());
        if (fixedScale) {
            float[] fArray = new float[]{1.0f, 1.0f};
            this.setSurfaceScale(fArray);
        }
    }

    public /* synthetic */ GlimpsePanel(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @Override
    public void setCallback(@NotNull GlimpseCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (!(this.eventListener == null)) {
            boolean bl = false;
            String string = "GlimpseEventListener already initialized";
            throw new IllegalStateException(string.toString());
        }
        this.eventListener = new GlimpseEventListener(callback);
        GlimpseEventListener glimpseEventListener = this.eventListener;
        if (glimpseEventListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventListener");
            glimpseEventListener = null;
        }
        this.addGLEventListener(glimpseEventListener);
        GLAnimatorControl gLAnimatorControl = this.getAnimator();
        if (gLAnimatorControl != null) {
            gLAnimatorControl.start();
        }
    }

    public GlimpsePanel() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J2\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lgraphics/glimpse/ui/GlimpsePanel$GlimpseEventListener;", "Lcom/jogamp/opengl/GLEventListener;", "callback", "Lgraphics/glimpse/GlimpseCallback;", "(Lgraphics/glimpse/GlimpseCallback;)V", "glimpseAdapter", "Lgraphics/glimpse/GlimpseAdapter;", "display", "", "drawable", "Lcom/jogamp/opengl/GLAutoDrawable;", "dispose", "init", "reshape", "x", "", "y", "width", "height", "ui"})
    public static final class GlimpseEventListener
    implements GLEventListener {
        @NotNull
        private final GlimpseCallback callback;
        private GlimpseAdapter glimpseAdapter;

        public GlimpseEventListener(@NotNull GlimpseCallback callback) {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            this.callback = callback;
        }

        public void init(@Nullable GLAutoDrawable drawable) {
            if (drawable == null) {
                boolean bl = false;
                String string = "GLAutoDrawable is null.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!drawable.getGL().isGL2ES2()) {
                boolean bl = false;
                String string = "OpenGL does not conform to GL2ES2 profile.";
                throw new IllegalArgumentException(string.toString());
            }
            GL2ES2 gL2ES2 = drawable.getGL().getGL2ES2();
            Intrinsics.checkNotNullExpressionValue((Object)gL2ES2, (String)"drawable.gl.gL2ES2");
            this.glimpseAdapter = new GlimpseAdapter(gL2ES2);
            GlimpseAdapter glimpseAdapter = this.glimpseAdapter;
            if (glimpseAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"glimpseAdapter");
                glimpseAdapter = null;
            }
            this.callback.onCreate(glimpseAdapter);
        }

        public void reshape(@Nullable GLAutoDrawable drawable, int x, int y, int width, int height) {
            GlimpseAdapter glimpseAdapter = this.glimpseAdapter;
            if (glimpseAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"glimpseAdapter");
                glimpseAdapter = null;
            }
            GlimpseCallback.DefaultImpls.onResize$default((GlimpseCallback)this.callback, (GlimpseAdapter)glimpseAdapter, (int)0, (int)0, (int)width, (int)height, (int)6, null);
        }

        public void display(@Nullable GLAutoDrawable drawable) {
            GlimpseAdapter glimpseAdapter = this.glimpseAdapter;
            if (glimpseAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"glimpseAdapter");
                glimpseAdapter = null;
            }
            this.callback.onRender(glimpseAdapter);
        }

        public void dispose(@Nullable GLAutoDrawable drawable) {
            GlimpseAdapter glimpseAdapter = this.glimpseAdapter;
            if (glimpseAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"glimpseAdapter");
                glimpseAdapter = null;
            }
            this.callback.onDestroy(glimpseAdapter);
        }
    }
}

