/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.ui;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import graphics.glimpse.logging.GlimpseLogger;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgraphics/glimpse/ui/GLCapabilitiesFactory;", "", "()V", "logger", "Lgraphics/glimpse/logging/GlimpseLogger;", "supportedProfiles", "", "", "create", "Lcom/jogamp/opengl/GLCapabilities;", "createGLCapabilities", "profile", "Lcom/jogamp/opengl/GLProfile;", "findGLProfile", "profileName", "ui"})
public final class GLCapabilitiesFactory {
    @NotNull
    public static final GLCapabilitiesFactory INSTANCE = new GLCapabilitiesFactory();
    @NotNull
    private static final GlimpseLogger logger = GlimpseLogger.Companion.create((Object)INSTANCE);
    @NotNull
    private static final List<String> supportedProfiles;

    private GLCapabilitiesFactory() {
    }

    @NotNull
    public final GLCapabilities create() {
        for (String profileName : supportedProfiles) {
            logger.debug("Obtaining GLProfile '" + profileName + "'");
            GLProfile profile = this.findGLProfile(profileName);
            if (profile != null) {
                logger.debug("Obtaining GLCapabilities for " + profile);
                GLCapabilities capabilities = this.createGLCapabilities(profile);
                if (capabilities == null) continue;
                return capabilities;
            }
            logger.warn("No GLProfile '" + profileName + "'");
        }
        throw new UnsupportedOperationException("Could not find any supported GLProfile");
    }

    private final GLProfile findGLProfile(String profileName) {
        GLProfile gLProfile;
        try {
            gLProfile = GLProfile.get((String)profileName);
        }
        catch (GLException ignored) {
            logger.error("Could not get GLProfile '" + profileName + "'");
            gLProfile = null;
        }
        return gLProfile;
    }

    private final GLCapabilities createGLCapabilities(GLProfile profile) {
        GLCapabilities gLCapabilities;
        try {
            gLCapabilities = new GLCapabilities(profile);
        }
        catch (GLException ignored) {
            logger.error("Could not get GLCapabilities for " + profile);
            gLCapabilities = null;
        }
        return gLCapabilities;
    }

    static {
        Object[] objectArray = new String[]{"GL2ES2", "GL2GL3", "GL3", "GL4ES3", "GL4", "GLES2", "GLES3", "GL3bc", "GL4bc"};
        supportedProfiles = CollectionsKt.listOf((Object[])objectArray);
    }
}

