/*
 * Copyright 2020-2023 Glimpse Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package graphics.glimpse.hud.dsl

import graphics.glimpse.hud.layouts.RowLayout
import graphics.glimpse.hud.layouts.VerticalAlignment
import graphics.glimpse.types.Vec2

internal class RowLayoutBuilder(
    parent: HudElementsBuilder,
    private val position: Vec2<Float>,
    private val alignment: VerticalAlignment,
    private val spacing: Float,
    private val delegate: HudElementsBuilderDelegate = HudElementsBuilderDelegate(parent)
) : HudElementsBuilder by delegate {

    fun build(): RowLayout =
        RowLayout(position, alignment, spacing).apply {
            for (element in delegate.elements) {
                addElement(element)
            }
        }
}
