/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.types;

import graphics.glimpse.types.Vec;
import graphics.glimpse.types.Vec3;
import graphics.glimpse.types.Vec4;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0001)B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003H\u0086\u0002J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003H\u0086\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eH\u0016J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\u0010\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u0003J\u001a\u0010$\u001a\u00020%2\b\b\u0002\u0010#\u001a\u00020\u00032\b\b\u0002\u0010&\u001a\u00020\u0003J\t\u0010'\u001a\u00020\u0000H\u0086\u0002J\t\u0010(\u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006*"}, d2={"Lgraphics/glimpse/types/Vec2;", "Lgraphics/glimpse/types/Vec;", "x", "", "y", "(FF)V", "u", "getU", "()F", "v", "getV", "getX", "getY", "component1", "component2", "copy", "div", "number", "equals", "", "other", "", "hashCode", "", "minus", "plus", "times", "toFloatArray", "", "toList", "", "toString", "", "toVec3", "Lgraphics/glimpse/types/Vec3;", "z", "toVec4", "Lgraphics/glimpse/types/Vec4;", "w", "unaryMinus", "unaryPlus", "Companion", "core"})
public final class Vec2
implements Vec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float x;
    private final float y;
    private static final int SIZE = 2;

    public Vec2(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final float getU() {
        return this.x;
    }

    public final float getV() {
        return this.y;
    }

    @NotNull
    public final Vec2 unaryPlus() {
        return this;
    }

    @NotNull
    public final Vec2 unaryMinus() {
        return new Vec2(-this.x, -this.y);
    }

    @NotNull
    public final Vec2 plus(@NotNull Vec2 other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vec2(this.x + other.x, this.y + other.y);
    }

    @NotNull
    public final Vec2 minus(@NotNull Vec2 other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vec2(this.x - other.x, this.y - other.y);
    }

    @NotNull
    public final Vec2 times(float number) {
        return new Vec2(this.x * number, this.y * number);
    }

    @NotNull
    public final Vec2 div(float number) {
        return new Vec2(this.x / number, this.y / number);
    }

    @NotNull
    public final Vec3 toVec3(float z) {
        return new Vec3(this.x, this.y, z);
    }

    public static /* synthetic */ Vec3 toVec3$default(Vec2 vec2, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        return vec2.toVec3(f);
    }

    @NotNull
    public final Vec4 toVec4(float z, float w) {
        return new Vec4(this.x, this.y, z, w);
    }

    public static /* synthetic */ Vec4 toVec4$default(Vec2 vec2, float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        return vec2.toVec4(f, f2);
    }

    @Override
    @NotNull
    public List<Float> toList() {
        Object[] objectArray = new Float[]{Float.valueOf(this.x), Float.valueOf(this.y)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public float[] toFloatArray() {
        float[] fArray = new float[]{this.x, this.y};
        return fArray;
    }

    public final float component1() {
        return this.x;
    }

    public final float component2() {
        return this.y;
    }

    @NotNull
    public final Vec2 copy(float x, float y) {
        return new Vec2(x, y);
    }

    public static /* synthetic */ Vec2 copy$default(Vec2 vec2, float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            f = vec2.x;
        }
        if ((n & 2) != 0) {
            f2 = vec2.y;
        }
        return vec2.copy(f, f2);
    }

    @NotNull
    public String toString() {
        return "Vec2(x=" + this.x + ", y=" + this.y + ")";
    }

    public int hashCode() {
        int result = Float.hashCode(this.x);
        result = result * 31 + Float.hashCode(this.y);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vec2)) {
            return false;
        }
        Vec2 vec2 = (Vec2)other;
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.x), (Object)Float.valueOf(vec2.x))) {
            return false;
        }
        return Intrinsics.areEqual((Object)Float.valueOf(this.y), (Object)Float.valueOf(vec2.y));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgraphics/glimpse/types/Vec2$Companion;", "", "()V", "SIZE", "", "fromList", "Lgraphics/glimpse/types/Vec2;", "list", "", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vec2 fromList(@NotNull List<Float> list) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (!(list.size() == 2)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            float x = ((Number)list.get(0)).floatValue();
            float y = ((Number)list.get(1)).floatValue();
            return new Vec2(x, y);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

