/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.types;

import graphics.glimpse.types.Angle;
import graphics.glimpse.types.AngleMathKt;
import graphics.glimpse.types.Mat4;
import graphics.glimpse.types.Vec3;
import graphics.glimpse.types.Vec3MathKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0016\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a$\u0010\f\u001a\u00020\u00012\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\r\u001a\u000e\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0003\u00a8\u0006\u0013"}, d2={"mirror", "Lgraphics/glimpse/types/Mat4;", "normal", "Lgraphics/glimpse/types/Vec3;", "origin", "rotation", "axis", "angle", "Lgraphics/glimpse/types/Angle;", "rotationX", "rotationY", "rotationZ", "scale", "", "x", "y", "z", "translation", "vector", "core"})
public final class TransformationMat4Kt {
    @NotNull
    public static final Mat4 translation(@NotNull Vec3 vector) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        float x = vector.component1();
        float y = vector.component2();
        float z = vector.component3();
        Object[] objectArray = new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(x), Float.valueOf(y), Float.valueOf(z), Float.valueOf(1.0f)};
        return new Mat4(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public static final Mat4 rotation(@NotNull Vec3 axis, @NotNull Angle angle) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        Intrinsics.checkNotNullParameter((Object)angle, (String)"angle");
        Vec3 vec3 = Vec3MathKt.normalize(axis);
        float x = vec3.component1();
        float y = vec3.component2();
        float z = vec3.component3();
        float sin = AngleMathKt.sin(angle);
        float cos = AngleMathKt.cos(angle);
        float nCos = 1.0f - AngleMathKt.cos(angle);
        Object[] objectArray = new Float[]{Float.valueOf(cos + x * x * nCos), Float.valueOf(x * y * nCos + z * sin), Float.valueOf(x * z * nCos - y * sin), Float.valueOf(0.0f), Float.valueOf(x * y * nCos - z * sin), Float.valueOf(cos + y * y * nCos), Float.valueOf(y * z * nCos + x * sin), Float.valueOf(0.0f), Float.valueOf(x * z * nCos + y * sin), Float.valueOf(y * z * nCos - x * sin), Float.valueOf(cos + z * z * nCos), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)};
        return new Mat4(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public static final Mat4 rotationX(@NotNull Angle angle) {
        Intrinsics.checkNotNullParameter((Object)angle, (String)"angle");
        float sin = AngleMathKt.sin(angle);
        float cos = AngleMathKt.cos(angle);
        Object[] objectArray = new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(cos), Float.valueOf(sin), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(-sin), Float.valueOf(cos), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)};
        return new Mat4(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public static final Mat4 rotationY(@NotNull Angle angle) {
        Intrinsics.checkNotNullParameter((Object)angle, (String)"angle");
        float sin = AngleMathKt.sin(angle);
        float cos = AngleMathKt.cos(angle);
        Object[] objectArray = new Float[]{Float.valueOf(cos), Float.valueOf(0.0f), Float.valueOf(-sin), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(sin), Float.valueOf(0.0f), Float.valueOf(cos), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)};
        return new Mat4(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public static final Mat4 rotationZ(@NotNull Angle angle) {
        Intrinsics.checkNotNullParameter((Object)angle, (String)"angle");
        float sin = AngleMathKt.sin(angle);
        float cos = AngleMathKt.cos(angle);
        Object[] objectArray = new Float[]{Float.valueOf(cos), Float.valueOf(sin), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(-sin), Float.valueOf(cos), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)};
        return new Mat4(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public static final Mat4 scale(float scale) {
        return TransformationMat4Kt.scale(scale, scale, scale);
    }

    @NotNull
    public static final Mat4 scale(float x, float y, float z) {
        Object[] objectArray = new Float[]{Float.valueOf(x), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(y), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(z), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)};
        return new Mat4(CollectionsKt.listOf((Object[])objectArray));
    }

    public static /* synthetic */ Mat4 scale$default(float f, float f2, float f3, int n, Object object) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            f2 = 1.0f;
        }
        if ((n & 4) != 0) {
            f3 = 1.0f;
        }
        return TransformationMat4Kt.scale(f, f2, f3);
    }

    @NotNull
    public static final Mat4 mirror(@NotNull Vec3 normal, @NotNull Vec3 origin) {
        Intrinsics.checkNotNullParameter((Object)normal, (String)"normal");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Vec3 vec3 = Vec3MathKt.normalize(normal);
        float a = vec3.component1();
        float b = vec3.component2();
        float c = vec3.component3();
        float d = origin.unaryMinus().dot(Vec3MathKt.normalize(normal));
        Object[] objectArray = new Float[]{Float.valueOf(1.0f - 2.0f * a * a), Float.valueOf(-2.0f * b * a), Float.valueOf(-2.0f * c * a), Float.valueOf(0.0f), Float.valueOf(-2.0f * a * b), Float.valueOf(1.0f - 2.0f * b * b), Float.valueOf(-2.0f * c * b), Float.valueOf(0.0f), Float.valueOf(-2.0f * a * c), Float.valueOf(-2.0f * b * c), Float.valueOf(1.0f - 2.0f * c * c), Float.valueOf(0.0f), Float.valueOf(-2.0f * a * d), Float.valueOf(-2.0f * b * d), Float.valueOf(-2.0f * c * d), Float.valueOf(1.0f)};
        return new Mat4(CollectionsKt.listOf((Object[])objectArray));
    }
}

