/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.types;

import graphics.glimpse.types.Angle;
import graphics.glimpse.types.AngleMathKt;
import graphics.glimpse.types.Mat4;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u001a6\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u001a&\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u00a8\u0006\u000e"}, d2={"frustum", "Lgraphics/glimpse/types/Mat4;", "left", "", "right", "bottom", "top", "near", "far", "orthographic", "perspective", "fovY", "Lgraphics/glimpse/types/Angle;", "aspect", "core"})
public final class ProjectionMat4Kt {
    @NotNull
    public static final Mat4 frustum(float left, float right, float bottom, float top, float near, float far) {
        if (!(near > 0.0f)) {
            boolean $i$a$-require-ProjectionMat4Kt$frustum$32 = false;
            String $i$a$-require-ProjectionMat4Kt$frustum$32 = "Near depth clipping plane must be at a positive distance";
            throw new IllegalArgumentException($i$a$-require-ProjectionMat4Kt$frustum$32.toString());
        }
        if (!(far > 0.0f)) {
            boolean $i$a$-require-ProjectionMat4Kt$frustum$42 = false;
            String $i$a$-require-ProjectionMat4Kt$frustum$42 = "Far depth clipping plane must be at a positive distance";
            throw new IllegalArgumentException($i$a$-require-ProjectionMat4Kt$frustum$42.toString());
        }
        float width = right - left;
        float height = top - bottom;
        float depth = near - far;
        Object[] objectArray = new Float[]{Float.valueOf(2.0f * near / width), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(2.0f * near / height), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf((right + left) / width), Float.valueOf((top + bottom) / height), Float.valueOf((far + near) / depth), Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(2.0f * far * near / depth), Float.valueOf(0.0f)};
        return new Mat4(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public static final Mat4 perspective(@NotNull Angle fovY, float aspect, float near, float far) {
        Intrinsics.checkNotNullParameter((Object)fovY, (String)"fovY");
        if (!(fovY.compareTo(Angle.Companion.getNullAngle()) > 0)) {
            boolean $i$a$-require-ProjectionMat4Kt$perspective$62 = false;
            String $i$a$-require-ProjectionMat4Kt$perspective$62 = "Field of view must be at a positive angle";
            throw new IllegalArgumentException($i$a$-require-ProjectionMat4Kt$perspective$62.toString());
        }
        if (!(fovY.compareTo(Angle.Companion.getStraightAngle()) < 0)) {
            boolean $i$a$-require-ProjectionMat4Kt$perspective$72 = false;
            String $i$a$-require-ProjectionMat4Kt$perspective$72 = "Field of view must be less than 180 degrees";
            throw new IllegalArgumentException($i$a$-require-ProjectionMat4Kt$perspective$72.toString());
        }
        if (!(aspect > 0.0f)) {
            boolean $i$a$-require-ProjectionMat4Kt$perspective$82 = false;
            String $i$a$-require-ProjectionMat4Kt$perspective$82 = "Aspect ratio must be a positive number";
            throw new IllegalArgumentException($i$a$-require-ProjectionMat4Kt$perspective$82.toString());
        }
        if (!(near > 0.0f)) {
            boolean $i$a$-require-ProjectionMat4Kt$perspective$92 = false;
            String $i$a$-require-ProjectionMat4Kt$perspective$92 = "Near depth clipping plane must be at a positive distance";
            throw new IllegalArgumentException($i$a$-require-ProjectionMat4Kt$perspective$92.toString());
        }
        if (!(far > 0.0f)) {
            boolean $i$a$-require-ProjectionMat4Kt$perspective$102 = false;
            String $i$a$-require-ProjectionMat4Kt$perspective$102 = "Far depth clipping plane must be at a positive distance";
            throw new IllegalArgumentException($i$a$-require-ProjectionMat4Kt$perspective$102.toString());
        }
        float top = AngleMathKt.tan(fovY.div(2.0f));
        float right = aspect * top;
        float depth = near - far;
        Object[] objectArray = new Float[]{Float.valueOf(1.0f / right), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f / top), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf((near + far) / depth), Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf((float)2 * near * far / depth), Float.valueOf(0.0f)};
        return new Mat4(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public static final Mat4 orthographic(float left, float right, float bottom, float top, float near, float far) {
        float width = right - left;
        float height = top - bottom;
        float depth = far - near;
        Object[] objectArray = new Float[]{Float.valueOf(2.0f / width), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(2.0f / height), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(-2.0f / depth), Float.valueOf(0.0f), Float.valueOf(-(right + left) / width), Float.valueOf(-(top + bottom) / height), Float.valueOf(-(near + far) / depth), Float.valueOf(1.0f)};
        return new Mat4(CollectionsKt.listOf((Object[])objectArray));
    }
}

