/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.types;

import graphics.glimpse.types.BaseMat;
import graphics.glimpse.types.Vec2;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00182\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0000H\u0016J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c0\u0003\u00a2\u0006\u0002\b\u000bJ\u0019\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001J\u0016\u0010\r\u001a\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0014J\u0016\u0010\u000e\u001a\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0014J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lgraphics/glimpse/types/Mat2;", "Lgraphics/glimpse/types/BaseMat;", "Lgraphics/glimpse/types/Vec2;", "elements", "", "", "(Ljava/util/List;)V", "getElements$core", "()Ljava/util/List;", "adj", "component1", "component1$core", "copy", "create", "createVector", "det", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "core"})
public final class Mat2
extends BaseMat<Mat2, Vec2> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Float> elements;
    private static final int MATRIX_DIMENSION = 2;
    @NotNull
    private static final Mat2 identity;

    public Mat2(@NotNull List<Float> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        super(2);
        this.elements = elements;
        this.validate();
    }

    @Override
    @NotNull
    public List<Float> getElements$core() {
        return this.elements;
    }

    @Override
    @NotNull
    protected Mat2 create(@NotNull List<Float> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return new Mat2(elements);
    }

    @Override
    @NotNull
    protected Vec2 createVector(@NotNull List<Float> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return Vec2.Companion.fromList(elements);
    }

    @Override
    public float det() {
        return ((Number)this.getElements$core().get(0)).floatValue() * ((Number)this.getElements$core().get(3)).floatValue() - ((Number)this.getElements$core().get(1)).floatValue() * ((Number)this.getElements$core().get(2)).floatValue();
    }

    @Override
    @NotNull
    public Mat2 adj() {
        Object[] objectArray = new Float[]{this.getElements$core().get(3), Float.valueOf(-((Number)this.getElements$core().get(1)).floatValue()), Float.valueOf(-((Number)this.getElements$core().get(2)).floatValue()), this.getElements$core().get(0)};
        return new Mat2(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public String toString() {
        return this.toString("Mat2");
    }

    @NotNull
    public final List<Float> component1$core() {
        return this.getElements$core();
    }

    @NotNull
    public final Mat2 copy(@NotNull List<Float> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return new Mat2(elements);
    }

    public static /* synthetic */ Mat2 copy$default(Mat2 mat2, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = mat2.getElements$core();
        }
        return mat2.copy(list);
    }

    public int hashCode() {
        return ((Object)this.getElements$core()).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Mat2)) {
            return false;
        }
        Mat2 mat2 = (Mat2)other;
        return Intrinsics.areEqual(this.getElements$core(), mat2.getElements$core());
    }

    static {
        Object[] objectArray = new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)};
        identity = new Mat2(CollectionsKt.listOf((Object[])objectArray));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lgraphics/glimpse/types/Mat2$Companion;", "", "()V", "MATRIX_DIMENSION", "", "identity", "Lgraphics/glimpse/types/Mat2;", "getIdentity", "()Lgraphics/glimpse/types/Mat2;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Mat2 getIdentity() {
            return identity;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

