/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.types;

import graphics.glimpse.types.Mat;
import graphics.glimpse.types.Vec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u0000*\u0014\b\u0000\u0010\u0001*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0002B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\u0011\u001a\u00028\u00002\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH$\u00a2\u0006\u0002\u0010\u0012J\u001b\u0010\u0013\u001a\u00028\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH$\u00a2\u0006\u0002\u0010\u0014J\u0019\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0096\u0002J\r\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001cH\u0002J\u0016\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010\u001d\u001a\u00028\u00012\u0006\u0010 \u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010!J\u0016\u0010\u001d\u001a\u00028\u00002\u0006\u0010\"\u001a\u00020\nH\u0096\u0002\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0004JF\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\t26\u0010\u001b\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\n0*H\u0004J\r\u0010-\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010.\u001a\u00020/H\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00060"}, d2={"Lgraphics/glimpse/types/BaseMat;", "M", "Lgraphics/glimpse/types/Mat;", "V", "Lgraphics/glimpse/types/Vec;", "dimension", "", "(I)V", "elements", "", "", "getElements$core", "()Ljava/util/List;", "indices", "Lkotlin/ranges/IntRange;", "getIndices", "()Lkotlin/ranges/IntRange;", "create", "(Ljava/util/List;)Lgraphics/glimpse/types/Mat;", "createVector", "(Ljava/util/List;)Lgraphics/glimpse/types/Vec;", "get", "row", "col", "inverse", "()Lgraphics/glimpse/types/Mat;", "map", "function", "Lkotlin/Function1;", "times", "other", "(Lgraphics/glimpse/types/Mat;)Lgraphics/glimpse/types/Mat;", "vector", "(Lgraphics/glimpse/types/Vec;)Lgraphics/glimpse/types/Vec;", "number", "(F)Lgraphics/glimpse/types/Mat;", "toFloatArray", "", "toString", "", "className", "transform", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "transpose", "validate", "", "core"})
public abstract class BaseMat<M extends Mat<M, V>, V extends Vec>
implements Mat<M, V> {
    private final int dimension;
    @NotNull
    private final IntRange indices;

    public BaseMat(int dimension) {
        this.dimension = dimension;
        this.indices = RangesKt.until((int)0, (int)this.dimension);
    }

    @NotNull
    public abstract List<Float> getElements$core();

    @NotNull
    protected final IntRange getIndices() {
        return this.indices;
    }

    protected final void validate() {
        if (!(this.getElements$core().size() == this.dimension * this.dimension)) {
            boolean bl = false;
            String string = "Invalid matrix size: " + this.getElements$core().size();
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public float get(int row, int col) {
        int $i$a$-require-BaseMat$get$32;
        IntRange intRange = this.indices;
        int n = intRange.getFirst();
        if (!(row <= intRange.getLast() ? n <= row : false)) {
            $i$a$-require-BaseMat$get$32 = 0;
            String $i$a$-require-BaseMat$get$32 = "Invalid row: " + row;
            throw new IllegalArgumentException($i$a$-require-BaseMat$get$32.toString());
        }
        intRange = this.indices;
        $i$a$-require-BaseMat$get$32 = intRange.getFirst();
        if (!(col <= intRange.getLast() ? $i$a$-require-BaseMat$get$32 <= col : false)) {
            boolean bl = false;
            String string = "Invalid column: " + col;
            throw new IllegalArgumentException(string.toString());
        }
        return ((Number)this.getElements$core().get(col * this.dimension + row)).floatValue();
    }

    @Override
    @NotNull
    public M times(@NotNull M other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return this.create(this.transform((Function2<Integer, Integer, Float>)((Function2)new Function2<Integer, Integer, Float>(this, other){
            final /* synthetic */ BaseMat<M, V> this$0;
            final /* synthetic */ M $other;
            {
                this.this$0 = $receiver;
                this.$other = $other;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Float invoke(int row, int col) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = (Iterable)this.this$0.getIndices();
                BaseMat<M, V> baseMat = this.this$0;
                M m = this.$other;
                boolean $i$f$map = false;
                void var7_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Float.valueOf(baseMat.get(row, (int)it) * m.get((int)it, col)));
                }
                return Float.valueOf(CollectionsKt.sumOfFloat((Iterable)((List)destination$iv$iv)));
            }
        })));
    }

    @NotNull
    protected abstract M create(@NotNull List<Float> var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<Float> transform(@NotNull Function2<? super Integer, ? super Integer, Float> function) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(function, (String)"function");
        Iterable $this$flatMap$iv = (Iterable)this.indices;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            int element$iv$iv;
            int col = element$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)this.getIndices();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void row;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(Float.valueOf(((Number)function.invoke((Object)((int)row), (Object)col)).floatValue()));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public V times(@NotNull V vector) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(vector, (String)"vector");
        List<Float> vectorValues = vector.toList();
        Iterable iterable = (Iterable)this.indices;
        BaseMat baseMat = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv2;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = (Iterable)this.getIndices();
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                void row;
                void col;
                int item$iv$iv2;
                int n2 = item$iv$iv2 = ((IntIterator)iterator2).nextInt();
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(Float.valueOf(((Number)vectorValues.get((int)col)).floatValue() * this.get((int)row, (int)col)));
            }
            collection.add(Float.valueOf(CollectionsKt.sumOfFloat((Iterable)((List)destination$iv$iv2))));
        }
        return baseMat.createVector((List)destination$iv$iv);
    }

    @NotNull
    protected abstract V createVector(@NotNull List<Float> var1);

    @Override
    @NotNull
    public M times(float number) {
        return this.create(this.map((Function1<Float, Float>)((Function1)new Function1<Float, Float>(number){
            final /* synthetic */ float $number;
            {
                this.$number = $number;
                super(1);
            }

            @NotNull
            public final Float invoke(float it) {
                return Float.valueOf(it * this.$number);
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Float> map(Function1<? super Float, Float> function) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getElements$core();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv.add(function.invoke(item$iv$iv));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public M transpose() {
        return this.create(this.transform((Function2<Integer, Integer, Float>)((Function2)new Function2<Integer, Integer, Float>(this){
            final /* synthetic */ BaseMat<M, V> this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Float invoke(int row, int col) {
                return Float.valueOf(this.this$0.get(col, row));
            }
        })));
    }

    @Override
    @NotNull
    public M inverse() {
        return this.adj().times(1.0f / this.det());
    }

    @Override
    @NotNull
    public float[] toFloatArray() {
        return CollectionsKt.toFloatArray((Collection)this.getElements$core());
    }

    @NotNull
    protected final String toString(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        IntRange intRange = this.indices;
        String string = className + "(data=[\n";
        return CollectionsKt.joinToString$default((Iterable)((Iterable)intRange), (CharSequence)"\n", (CharSequence)string, (CharSequence)"\n])", (int)0, null, (Function1)((Function1)new Function1<Integer, CharSequence>(this){
            final /* synthetic */ BaseMat<M, V> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CharSequence invoke(int row) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = (Iterable)this.this$0.getIndices();
                BaseMat<M, V> baseMat = this.this$0;
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void col;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Float.valueOf(baseMat.get(row, (int)col)));
                }
                return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", (CharSequence)"    ", null, (int)0, null, null, (int)60, null);
            }
        }), (int)24, null);
    }
}

